/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import com.mna.api.items.IRelic;
import de.joh.dmnr.api.item.ScrollableItem;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class WeatherFairyStaffItem
extends SwordItem
implements ScrollableItem,
IRelic {
    public WeatherFairyStaffItem() {
        super((Tier)Tiers.IRON, 3, -3.1f, new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.EPIC).setNoRepair());
    }

    @Override
    public int getIteratorSize(Player player) {
        return 3;
    }

    @Override
    public int incrementIterator(ItemStack stack, boolean inverted, Player player) {
        int value = ScrollableItem.super.incrementIterator(stack, inverted, player);
        player.m_5661_((Component)Component.m_237113_((String)(Component.m_237115_((String)"dmnr.feedback.selected.weather").getString() + this.getSelectedWeatherText(stack).getString())), true);
        return value;
    }

    public MutableComponent getSelectedWeatherText(ItemStack stack) {
        return switch (this.getIterator(stack)) {
            case 1 -> Component.m_237115_((String)"dmnr.feedback.selected.weather.rain");
            case 2 -> Component.m_237115_((String)"dmnr.feedback.selected.weather.storm");
            default -> Component.m_237115_((String)"dmnr.feedback.selected.weather.sunshine");
        };
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(world, user, hand);
        if (!world.m_5776_()) {
            if (((Biome)world.m_204166_(user.m_20183_()).m_203334_()).m_264600_(user.m_20183_()) == Biome.Precipitation.NONE) {
                user.m_5661_((Component)Component.m_237115_((String)"dmnr.feedback.weather.not_changable"), true);
            } else {
                user.m_5661_((Component)Component.m_237113_((String)(Component.m_237115_((String)"dmnr.feedback.selected.weather").getString() + this.getSelectedWeatherText(user.m_21120_(hand)).getString())), true);
                switch (this.getIterator(user.m_21120_(hand))) {
                    case 1: {
                        ((ServerLevel)world).m_8606_(0, 6000, true, false);
                        break;
                    }
                    case 2: {
                        ((ServerLevel)world).m_8606_(0, 6000, true, true);
                        break;
                    }
                    default: {
                        ((ServerLevel)world).m_8606_(30000, 0, false, false);
                    }
                }
            }
        }
        user.m_36335_().m_41524_((Item)this, 200);
        return ar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"dmnr.feedback.selected.weather"));
        tooltip.add((Component)Component.m_237115_((String)"item.dmnr.weather_fairy_staff.lore_1").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)this.getSelectedWeatherText(stack));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.dmnr.weatherferystaff.how_to_change"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@NotNull ItemStack itemStack) {
        return true;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return super.damageItem(stack, 0, entity, onBroken);
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(attacker.m_9236_());
        if (lightningbolt != null) {
            lightningbolt.m_146884_(target.m_20182_());
            attacker.m_9236_().m_7967_((Entity)lightningbolt);
        }
        return super.m_7579_(stack, target, attacker);
    }
}

