/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import com.mna.api.items.TieredItem;
import de.joh.dmnr.networking.ModMessages;
import de.joh.dmnr.networking.packet.ToggleWaterBraceletS2CPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class WaterBraceletItem
extends TieredItem
implements ICurioItem {
    private final AttributeModifier swimmingMod;

    public WaterBraceletItem(int level) {
        super(new Item.Properties().m_41487_(1));
        this.swimmingMod = new AttributeModifier("dmnr_water_bracelet", (double)(1.5f * (float)level), AttributeModifier.Operation.ADDITION);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        AttributeInstance swimmingAttribute = slotContext.entity().m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        if (swimmingAttribute != null && !swimmingAttribute.m_22109_(this.swimmingMod)) {
            swimmingAttribute.m_22118_(this.swimmingMod);
        }
        if (slotContext.entity() instanceof ServerPlayer) {
            ModMessages.sendToPlayer(new ToggleWaterBraceletS2CPacket(true), (ServerPlayer)slotContext.entity());
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        AttributeInstance swimmingAttribute = slotContext.entity().m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        if (swimmingAttribute != null) {
            swimmingAttribute.m_22130_(this.swimmingMod);
        }
        if (slotContext.entity() instanceof ServerPlayer) {
            ModMessages.sendToPlayer(new ToggleWaterBraceletS2CPacket(false), (ServerPlayer)slotContext.entity());
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.m_20146_() < livingEntity.m_6062_()) {
            livingEntity.m_20301_(livingEntity.m_6062_());
        }
    }
}

