/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import com.mna.api.faction.IFaction;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.items.ITieredItem;
import com.mna.factions.Factions;
import de.joh.dmnr.common.item.HydraCrownItem;
import de.joh.dmnr.common.item.material.ArmorMaterials;
import java.util.function.Consumer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class NightGogglesItem
extends ArmorItem
implements ITieredItem<HydraCrownItem>,
IFactionSpecific,
ICurioItem {
    private int tier = -1;

    public NightGogglesItem() {
        super((ArmorMaterial)ArmorMaterials.NIGHT_GOGGLES_MATERIAL, ArmorItem.Type.HELMET, new Item.Properties().m_41487_(1));
    }

    public void tick(LivingEntity livingEntity) {
        MobEffectInstance vision = livingEntity.m_21124_(MobEffects.f_19611_);
        if (vision == null) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, -1, 0, false, false));
        }
        livingEntity.m_21195_(MobEffects.f_19610_);
        livingEntity.m_21195_(MobEffects.f_19604_);
    }

    public void unequip(LivingEntity livingEntity) {
        livingEntity.m_21195_(MobEffects.f_19611_);
        MobEffectInstance vision = livingEntity.m_21124_(MobEffects.f_19604_);
        if (vision == null) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0, false, false));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        this.unequip(slotContext.entity());
    }

    public void onDiscard(LivingEntity entity) {
        this.unequip(entity);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        super.onArmorTick(stack, level, player);
        this.tick((LivingEntity)player);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        this.tick(slotContext.entity());
    }

    public IFaction getFaction() {
        return Factions.UNDEAD;
    }

    public void setCachedTier(int tier) {
        this.tier = tier;
    }

    public int getCachedTier() {
        return this.tier;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return super.damageItem(stack, 0, entity, onBroken);
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }
}

