/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import com.mna.api.faction.IFaction;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.items.ITieredItem;
import com.mna.factions.Factions;
import de.joh.dmnr.common.init.EffectInit;
import de.joh.dmnr.common.item.material.ArmorMaterials;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class HydraCrownItem
extends ArmorItem
implements ITieredItem<HydraCrownItem>,
IFactionSpecific,
ICurioItem {
    private int tier = -1;
    Map<MobEffect, TreeMap<Integer, Integer>> effects = Map.of(MobEffects.f_19605_, new TreeMap<Integer, Integer>(Map.of(10, 0)), MobEffects.f_19606_, new TreeMap<Integer, Integer>(Map.of(30, 1, 50, 0)), (MobEffect)EffectInit.ULTIMATE_ARMOR.get(), new TreeMap<Integer, Integer>(Map.of(10, 3, 20, 2, 35, 1, 50, 0)), MobEffects.f_19596_, new TreeMap<Integer, Integer>(Map.of(20, 2, 30, 2, 50, 1, 70, 0)), MobEffects.f_19603_, new TreeMap<Integer, Integer>(Map.of(30, 1, 70, 0)), MobEffects.f_19600_, new TreeMap<Integer, Integer>(Map.of(10, 4, 20, 3, 30, 2, 40, 1, 50, 0)));

    public HydraCrownItem() {
        super((ArmorMaterial)ArmorMaterials.HYDRA_CROWN_MATERIAL, ArmorItem.Type.HELMET, new Item.Properties().m_41487_(1));
    }

    public void tick(LivingEntity livingEntity) {
        boolean applied = false;
        int hp_percent = (int)(100.0f * livingEntity.m_21223_() / livingEntity.m_21233_());
        for (Map.Entry<MobEffect, TreeMap<Integer, Integer>> effect : this.effects.entrySet()) {
            MobEffectInstance current;
            Map.Entry<Integer, Integer> thresholdEntry = effect.getValue().ceilingEntry(hp_percent);
            if (thresholdEntry == null || (current = livingEntity.m_21124_(effect.getKey())) != null && current.m_19564_() >= thresholdEntry.getValue() && (current.m_19564_() != thresholdEntry.getValue().intValue() || current.m_19557_() >= 40)) continue;
            livingEntity.m_7292_(new MobEffectInstance(effect.getKey(), 300, thresholdEntry.getValue().intValue(), false, false, false));
            applied = true;
        }
        if (applied && livingEntity instanceof Player) {
            this.usedByPlayer((Player)livingEntity);
        }
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        super.onArmorTick(stack, level, player);
        this.tick((LivingEntity)player);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        this.tick(slotContext.entity());
    }

    public IFaction getFaction() {
        return Factions.UNDEAD;
    }

    public void setCachedTier(int tier) {
        this.tier = tier;
    }

    public int getCachedTier() {
        return this.tier;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return super.damageItem(stack, 0, entity, onBroken);
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }
}

