/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import com.mna.Registries;
import com.mna.api.ManaAndArtificeMod;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.items.ChargeableItem;
import de.joh.dmnr.common.init.EffectInit;
import de.joh.dmnr.common.init.ItemInit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.registries.IForgeRegistry;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class FactionAmuletItem
extends ChargeableItem
implements IForgeItem,
ICurioItem {
    public FactionAmuletItem(Item.Properties itemProperties) {
        super(itemProperties, 2500.0f);
    }

    protected boolean tickEffect(ItemStack stack, Player player, Level world, int slot, float mana, boolean selected) {
        player.getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> ((IForgeRegistry)Registries.Factions.get()).getValues().forEach(faction -> {
            if (p.getRaidChance(faction) >= 0.5 && this.isEquippedAndHasMana((LivingEntity)player, 1.0f, true)) {
                p.setRaidChance(faction, 0.0);
            }
        }));
        return false;
    }

    protected boolean tickCurio() {
        return true;
    }

    public static void eventHandlePeaceOffering(LivingChangeTargetEvent event) {
        if (event.getEntity() instanceof IFactionEnemy) {
            if (event.getNewTarget() == null) {
                return;
            }
            if (event.getNewTarget().m_21023_((MobEffect)EffectInit.PEACE_EFFECT.get())) {
                event.setNewTarget(null);
            } else if (!event.getNewTarget().m_21023_((MobEffect)EffectInit.BROKEN_PEACE_EFFECT.get()) && ((ChargeableItem)ItemInit.FACTION_AMULET.get()).isEquippedAndHasMana(event.getNewTarget(), 50.0f, true)) {
                event.getNewTarget().m_7292_(new MobEffectInstance((MobEffect)EffectInit.PEACE_EFFECT.get(), 600));
                event.setNewTarget(null);
            }
        }
    }

    public static void eventHandleDeclarationOfWar(LivingHurtEvent event) {
        LivingEntity sourceEntity;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (sourceEntity = (LivingEntity)entity).m_21023_((MobEffect)EffectInit.PEACE_EFFECT.get())) {
            LivingEntity targetEntity = event.getEntity();
            AtomicReference<Object> faction = new AtomicReference<Object>(null);
            if (targetEntity instanceof Player) {
                Player player = (Player)targetEntity;
                player.getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> faction.set(p.getAlliedFaction()));
            }
            if ((targetEntity instanceof IFactionEnemy || faction.get() != null) && sourceEntity instanceof LivingEntity) {
                sourceEntity.m_21195_((MobEffect)EffectInit.PEACE_EFFECT.get());
                sourceEntity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.BROKEN_PEACE_EFFECT.get(), 12000));
                if (sourceEntity instanceof Player) {
                    sourceEntity.m_9236_().m_214150_(null, sourceEntity.m_20185_(), sourceEntity.m_20186_(), sourceEntity.m_20189_(), (SoundEvent)SoundEvents.f_12355_.get(), SoundSource.PLAYERS, 1.0f, 0.9f + (float)Math.random() * 0.2f, 0L);
                }
            }
        }
    }
}

