/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import com.mna.api.affinity.Affinity;
import com.mna.api.events.SpellCastEvent;
import com.mna.api.faction.IFaction;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.items.TieredItem;
import com.mna.factions.Factions;
import de.joh.dmnr.common.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeItem;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DevilRingItem
extends TieredItem
implements IForgeItem,
ICurioItem,
IFactionSpecific {
    private int _tier = -1;

    public void setCachedTier(int tier) {
        this._tier = tier;
    }

    public int getCachedTier() {
        return this._tier;
    }

    public DevilRingItem(Item.Properties itemProperties) {
        super(itemProperties);
    }

    public IFaction getFaction() {
        return Factions.DEMONS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@Nullable ItemStack itemStack) {
        return true;
    }

    public static void eventHandleTurnIntoHellfire(SpellCastEvent event) {
        LivingEntity caster = event.getSource().getCaster();
        if (caster != null && CuriosApi.getCuriosHelper().findFirstCurio(caster, (Item)ItemInit.DEVIL_RING.get()).isPresent() && (event.getSpell().getHighestAffinity() == Affinity.FIRE || event.getSpell().getHighestAffinity() == Affinity.LIGHTNING)) {
            event.getSpell().setOverrideAffinity(Affinity.HELLFIRE);
        }
    }
}

