/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import com.mna.api.items.TieredItem;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CollectorItem
extends TieredItem
implements ICurioItem {
    private final String curioType;
    private final UUID curiosID;
    private final AttributeModifier curiosMod;

    public CollectorItem(String curioType, int count) {
        super(new Item.Properties().m_41487_(1));
        this.curioType = curioType;
        String id = "dmnr_collector_of_" + curioType + "_item";
        this.curiosID = UUID.nameUUIDFromBytes(id.getBytes());
        this.curiosMod = new AttributeModifier(this.curiosID, id, (double)count, AttributeModifier.Operation.ADDITION);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity()).resolve().flatMap(x -> x.getStacksHandler(this.curioType));
        opt.ifPresent(iCurioStacksHandler -> iCurioStacksHandler.addTransientModifier(this.curiosMod));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity()).resolve().flatMap(x -> x.getStacksHandler(this.curioType));
        opt.ifPresent(iCurioStacksHandler -> iCurioStacksHandler.removeModifier(this.curiosID));
    }
}

