/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import com.mna.api.events.ComponentApplyingEvent;
import com.mna.api.items.ITieredItem;
import com.mna.api.spells.SpellPartTags;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.base.ItemBagBase;
import com.mna.items.filters.ItemFilterGroup;
import com.mna.items.ritual.PlayerCharm;
import de.joh.dmnr.api.util.PlayerCharmFilter;
import de.joh.dmnr.client.gui.NamedBraceletOfFriendship;
import de.joh.dmnr.common.init.ItemInit;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BraceletOfFriendshipItem
extends ItemBagBase
implements ICurioItem,
ITieredItem<BraceletOfFriendshipItem> {
    private int _tier = -1;

    public void setCachedTier(int tier) {
        this._tier = tier;
    }

    public int getCachedTier() {
        return this._tier;
    }

    public BraceletOfFriendshipItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public Player[] getPlayerTargets(ItemStack stack, Level world) {
        ArrayList<Player> ret = new ArrayList<Player>();
        ItemInventoryBase inv = new ItemInventoryBase(stack);
        for (int i = 0; i < 6; ++i) {
            ItemStack item = inv.getStackInSlot(i);
            if (item.m_41720_() != com.mna.items.ItemInit.PLAYER_CHARM.get() || ((PlayerCharm)item.m_41720_()).GetPlayerTarget(item, world) == null) continue;
            ret.add(((PlayerCharm)item.m_41720_()).GetPlayerTarget(item, world));
        }
        return ret.toArray(new Player[0]);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack held;
        if (!world.f_46443_ && this.openGuiIfModifierPressed(held = player.m_21120_(hand), player, world)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)held);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    public ItemFilterGroup filterGroup() {
        return PlayerCharmFilter.ANY_PLAYER_CHARM;
    }

    public MenuProvider getProvider(ItemStack itemStack) {
        return new NamedBraceletOfFriendship(itemStack);
    }

    @Nullable
    public static Player playerOrOwner(Entity entity) {
        while (entity instanceof OwnableEntity) {
            entity = ((OwnableEntity)entity).m_269323_();
        }
        return entity instanceof Player ? (Player)entity : null;
    }

    private static boolean shouldProtect(LivingEntity sourceEntity, Entity target) {
        if (sourceEntity == target) {
            return false;
        }
        Player referenceTarget = BraceletOfFriendshipItem.playerOrOwner(target);
        if (referenceTarget == null) {
            return false;
        }
        for (SlotResult result : CuriosApi.getCuriosHelper().findCurios(sourceEntity, (Item)ItemInit.BRACELET_OF_FRIENDSHIP.get())) {
            ItemStack stack = result.stack();
            Item item = stack.m_41720_();
            if (!(item instanceof BraceletOfFriendshipItem)) continue;
            BraceletOfFriendshipItem bracelet = (BraceletOfFriendshipItem)item;
            if (referenceTarget == sourceEntity) {
                return true;
            }
            for (Player friend : bracelet.getPlayerTargets(stack, sourceEntity.m_9236_())) {
                if (friend != referenceTarget) continue;
                return true;
            }
        }
        return false;
    }

    public static void eventHandleProtectFriends(ComponentApplyingEvent event) {
        if (event.getComponent().getUseTag() == SpellPartTags.HARMFUL && event.getTarget().isLivingEntity() && BraceletOfFriendshipItem.shouldProtect(event.getSource().getCaster(), event.getTarget().getEntity())) {
            event.setCanceled(true);
        }
    }

    public static void eventHandleProtectFriends(LivingAttackEvent event) {
        LivingEntity sourceEntity;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && BraceletOfFriendshipItem.shouldProtect(sourceEntity = (LivingEntity)entity, (Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }
}

