/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.item.IDragonMagicContainerItem;
import de.joh.dmnr.api.item.ScrollableItem;
import de.joh.dmnr.common.util.Registries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BlankUpgradeSealItem
extends Item
implements ScrollableItem {
    public BlankUpgradeSealItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    @Override
    public int getIteratorSize(Player player) {
        CompoundTag nbt;
        ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
        int dragon_magics = 0;
        if (offHandStack.m_41720_() instanceof IDragonMagicContainerItem && offHandStack.m_41783_() != null && offHandStack.m_41783_().m_128441_("dmnrarmor_upgrade") && !(nbt = offHandStack.m_41783_().m_128469_("dmnrarmor_upgrade")).m_128431_().isEmpty()) {
            for (String key : nbt.m_128431_()) {
                if (nbt.m_128451_(key) <= 0) continue;
                ++dragon_magics;
            }
        }
        return dragon_magics;
    }

    @Nullable
    public String getUpgradeById(ItemStack dragonContainer, int id) {
        CompoundTag nbt;
        if (dragonContainer.m_41720_() instanceof IDragonMagicContainerItem && dragonContainer.m_41783_() != null && dragonContainer.m_41783_().m_128441_("dmnrarmor_upgrade") && !(nbt = dragonContainer.m_41783_().m_128469_("dmnrarmor_upgrade")).m_128431_().isEmpty()) {
            ArrayList<String> sortedList = new ArrayList<String>(nbt.m_128431_());
            Collections.sort(sortedList);
            Predicate<String> condition = key -> nbt.m_128451_(key) <= 0;
            sortedList.removeIf(condition);
            if (sortedList.size() <= id) {
                return null;
            }
            return (String)sortedList.get(id);
        }
        return null;
    }

    @Override
    public int incrementIterator(ItemStack stack, boolean inverted, Player player) {
        int value = ScrollableItem.super.incrementIterator(stack, inverted, player);
        ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
        String upgrade = this.getUpgradeById(offHandStack, value);
        if (upgrade != null) {
            player.m_5661_((Component)Component.m_237115_((String)upgrade), true);
        }
        return value;
    }

    public void m_5929_(@NotNull Level world, @NotNull LivingEntity player, @NotNull ItemStack stack, int count) {
        if (count <= 1) {
            int value = this.getIterator(stack);
            ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
            Item item = offHandStack.m_41720_();
            if (item instanceof IDragonMagicContainerItem) {
                ArmorUpgrade installedArmorUpgrade;
                IDragonMagicContainerItem dmContainerItem = (IDragonMagicContainerItem)item;
                String upgradeKey = this.getUpgradeById(offHandStack, value);
                if (upgradeKey != null && (installedArmorUpgrade = (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(new ResourceLocation(upgradeKey))) != null) {
                    int level = dmContainerItem.getUpgradeLevel(offHandStack, installedArmorUpgrade);
                    dmContainerItem.addDragonMagicToItem(offHandStack, installedArmorUpgrade, level - 1, false);
                    player.m_21008_(player.m_7655_(), new ItemStack((ItemLike)installedArmorUpgrade.getSeal()));
                }
            }
            player.m_9236_().m_214150_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 0.9f + (float)Math.random() * 0.2f, 0L);
            if (player instanceof Player) {
                ((Player)player).m_36335_().m_41524_((Item)this, 20);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int m_8105_(@NotNull ItemStack itemstack) {
        return 40;
    }
}

