/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.item;

import com.mna.api.items.IRelic;
import de.joh.dmnr.common.item.IDamageAdjustmentItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;

public class BattleMageRingItem
extends Item
implements IDamageAdjustmentItem,
IRelic {
    public BattleMageRingItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    @Override
    public boolean canAdjustAttacking(LivingHurtEvent event, Player attacker, ItemStack damageAdjustmentItem) {
        return event.getSource().m_269533_(DamageTypeTags.f_268490_);
    }

    @Override
    public float adjustAttacking(LivingHurtEvent event, Player attacker, ItemStack damageAdjustmentItem, float amount) {
        AttributeInstance attackAttribute = attacker.m_21051_(Attributes.f_22281_);
        int attack = attackAttribute != null ? (int)Math.round(attackAttribute.m_22135_()) : 1;
        attack = Math.max(1, attack);
        return amount * (1.0f + ((float)attack - 1.0f) / 15.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level worldIn, List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.dmnr.battle_mage_ring.lore_1").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.dmnr.battle_mage_ring.lore_2").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"  "));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean canAdjustDefending(LivingHurtEvent event, Player defender, ItemStack damageAdjustmentItem) {
        return false;
    }

    @Override
    public float adjustDefending(LivingHurtEvent event, Player defender, ItemStack damageAdjustmentItem, float amount) {
        return amount;
    }
}

