/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.event;

import com.mna.api.config.GeneralConfigValues;
import com.mna.api.entities.IFactionEnemy;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.sorcery.EntityDecoy;
import com.mna.factions.Factions;
import com.mna.items.artifice.FactionSpecificSpellModifierRing;
import com.mna.tools.ProjectileHelper;
import com.mna.tools.SummonUtils;
import de.joh.dmnr.api.item.DragonMageArmorItem;
import de.joh.dmnr.capabilities.dragonmagic.ArmorUpgradeHelper;
import de.joh.dmnr.common.init.ArmorUpgradeInit;
import de.joh.dmnr.common.init.ItemInit;
import de.joh.dmnr.common.item.BraceletOfFriendshipItem;
import de.joh.dmnr.common.item.DragonCoreItem;
import de.joh.dmnr.common.item.FactionAmuletItem;
import de.joh.dmnr.common.item.IDamageAdjustmentItem;
import de.joh.dmnr.common.item.RevengeCharmItem;
import de.joh.dmnr.common.item.VoidfeatherCharmItem;
import de.joh.dmnr.common.util.CommonConfig;
import de.joh.dmnr.common.util.ProjectileReflectionHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableFloat;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="dmnr", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DamageEventHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        Entity sourceEntity = event.getSource().m_7639_();
        LivingEntity targetEntity = event.getEntity();
        RevengeCharmItem.handleRevengeCharm(event);
        if (targetEntity instanceof Player) {
            DragonMageArmorItem dragonMageArmor;
            Item item;
            player = (Player)targetEntity;
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (!chest.m_41619_() && !player.m_9236_().f_46443_ && (item = chest.m_41720_()) instanceof DragonMageArmorItem && (dragonMageArmor = (DragonMageArmorItem)item).isSetEquipped((LivingEntity)player)) {
                DragonMageArmorItem.applySpell(chest, false, player, sourceEntity);
                if (sourceEntity != null && sourceEntity != player) {
                    DragonMageArmorItem.applySpell(chest, true, player, sourceEntity);
                }
            }
            event.setAmount(event.getAmount() * (1.0f - (float)ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.DAMAGE_RESISTANCE) * CommonConfig.getDamageResistanceDamageReductionPerLevel()));
        }
        if (sourceEntity instanceof Player) {
            player = (Player)sourceEntity;
            event.setAmount(event.getAmount() * (1.0f + (float)ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.DAMAGE_BOOST) * 0.25f));
        }
        FactionAmuletItem.eventHandleDeclarationOfWar(event);
        if (IDamageAdjustmentItem.eventHandleDamageAdjustment(event)) {
            return;
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        FactionAmuletItem.eventHandlePeaceOffering(event);
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (VoidfeatherCharmItem.eventHandleVoidProtection(event)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_) {
                if (source.m_269533_(DamageTypeTags.f_268745_) && ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.MAJOR_FIRE_RESISTANCE) >= 1) {
                    event.setCanceled(true);
                    return;
                }
                if (source.m_269533_(DamageTypeTags.f_268745_) && ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.MINOR_FIRE_RESISTANCE) >= 1) {
                    AtomicBoolean doReturn = new AtomicBoolean(false);
                    player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                        if (magic.getCastingResource().hasEnoughAbsolute((LivingEntity)player, (float)((Integer)CommonConfig.FIRE_RESISTANCE_MANA_PER_FIRE_DAMAGE.get()).intValue() / 5.0f)) {
                            magic.getCastingResource().consume((LivingEntity)player, (float)((Integer)CommonConfig.FIRE_RESISTANCE_MANA_PER_FIRE_DAMAGE.get()).intValue() / 5.0f);
                            event.setCanceled(true);
                            if (player.m_6060_()) {
                                player.m_20095_();
                            }
                            doReturn.set(true);
                        }
                    });
                    if (doReturn.get()) {
                        return;
                    }
                }
                if (source.m_269533_(DamageTypeTags.f_268415_) && ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.EXPLOSION_RESISTANCE) == 1) {
                    event.setCanceled(true);
                    return;
                }
                if (source.m_269533_(DamageTypeTags.f_268549_)) {
                    if (ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.JUMP) >= 1) {
                        if (event.getAmount() - (float)(ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.JUMP) * 3) <= 0.0f) {
                            event.setCanceled(true);
                            return;
                        }
                    } else if (ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.BURNING_FRENZY) >= 1 && event.getAmount() - (float)(ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.BURNING_FRENZY) * 9) <= 0.0f) {
                        event.setCanceled(true);
                        return;
                    }
                }
                if ((source.m_269533_(DamageTypeTags.f_268549_) || source.m_276093_(DamageTypes.f_268576_)) && ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.KINETIC_RESISTANCE) == 1) {
                    event.setCanceled(true);
                    return;
                }
                if (source.m_7640_() instanceof Projectile && ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.PROJECTILE_REFLECTION) > 0 && ProjectileReflectionHelper.consumeReflectCharge(player)) {
                    event.setCanceled(true);
                    ProjectileHelper.ReflectProjectile((LivingEntity)player, (Projectile)((Projectile)source.m_7640_()), (boolean)true, (float)10.0f);
                    return;
                }
            }
            if ((source.m_269533_(DamageTypeTags.f_268549_) || source.m_276093_(DamageTypes.f_268576_)) && CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ItemInit.ANGEL_RING.get()).isPresent()) {
                event.setCanceled(true);
                return;
            }
        }
        BraceletOfFriendshipItem.eventHandleProtectFriends(event);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_) {
                if (event.getSource().m_269533_(DamageTypeTags.f_268549_)) {
                    int amount;
                    if (ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.JUMP) >= 1) {
                        int amount2 = (int)event.getAmount() - ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.JUMP) * 3;
                        if (amount2 > 0) {
                            event.setAmount((float)amount2);
                        }
                    } else if (ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.BURNING_FRENZY) >= 1 && (amount = (int)event.getAmount() - ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.BURNING_FRENZY) * 9) > 0) {
                        event.setAmount((float)amount);
                    }
                }
                if (ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.MIST_FORM) >= 1 && !event.getSource().m_269533_(DamageTypeTags.f_268738_) && player.m_21223_() > 1.0f && event.getAmount() > player.m_21223_()) {
                    player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.MIST_FORM.get(), 200, 0, true, true));
                    player.m_21153_(1.0f);
                    event.setCanceled(true);
                }
            }
        }
        LivingEntity living = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (source instanceof LivingEntity && source != event.getEntity() && source instanceof Player) {
            Player sourcePlayer = (Player)source;
            sourcePlayer.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                float souls;
                int manaRegenLevel;
                if (p.getAlliedFaction() == Factions.UNDEAD && !sourcePlayer.m_9236_().f_46443_ && (manaRegenLevel = ArmorUpgradeHelper.getUpgradeLevel(sourcePlayer, ArmorUpgradeInit.MANA_REGEN)) > 0 && (souls = DamageEventHandler.getSoulsRestored(sourcePlayer, (Entity)living)) > 0.0f) {
                    sourcePlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                        m.getCastingResource().restore(souls * 0.05f * (float)manaRegenLevel);
                        m.getCastingResource().setNeedsSync();
                    });
                }
            });
        }
        if (event.getAmount() <= 0.0f) {
            event.setCanceled(true);
        }
    }

    private static float getSoulsRestored(Player soulRecipient, Entity target) {
        if (soulRecipient == null) {
            return 0.0f;
        }
        if (!(!(target instanceof LivingEntity) || target instanceof PathfinderMob && SummonUtils.isSummon((Entity)target))) {
            if (target instanceof EntityDecoy) {
                return 0.0f;
            }
            MutableFloat restoreAmount = new MutableFloat(1.0f);
            if (target instanceof Player) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForPlayerKill);
            } else if (target instanceof Villager) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForVillagerKill);
            } else if (target instanceof IFactionEnemy) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForFactionMobKill);
            } else if (((LivingEntity)target).m_21222_()) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForUndeadKill);
            } else if (target instanceof Animal) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForAnimalKill);
            } else if (target instanceof AbstractGolem) {
                restoreAmount.setValue(0.0f);
            } else if (target instanceof Mob) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForMobKill);
            }
            if (((LivingEntity)target).m_21023_((MobEffect)EffectInit.SOUL_VULNERABILITY.get())) {
                restoreAmount.setValue(restoreAmount.getValue().floatValue() * 5.0f);
            }
            if (((FactionSpecificSpellModifierRing)com.mna.items.ItemInit.BONE_RING.get()).isEquippedAndHasMana((LivingEntity)soulRecipient, 3.5f, true)) {
                restoreAmount.setValue(restoreAmount.getValue().floatValue() * 2.25f);
            }
            return restoreAmount.getValue().floatValue();
        }
        return 0.0f;
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        DragonCoreItem.eventHandleDragonDeath(event);
    }
}

