/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.event;

import de.joh.dmnr.api.item.DragonMageArmorItem;
import de.joh.dmnr.capabilities.dragonmagic.ArmorUpgradeHelper;
import de.joh.dmnr.common.effects.beneficial.ElytraMobEffect;
import de.joh.dmnr.common.init.ArmorUpgradeInit;
import de.joh.dmnr.common.init.ItemInit;
import de.joh.dmnr.common.item.NightGogglesItem;
import de.joh.dmnr.networking.ModMessages;
import de.joh.dmnr.networking.packet.ToggleBurningFrenzyS2CPacket;
import de.joh.dmnr.networking.packet.ToggleMajorFireResS2CPacket;
import de.joh.dmnr.networking.packet.ToggleWaterBraceletS2CPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="dmnr", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_()) {
            int level = ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.JUMP);
            if (player.m_20142_() && level >= 1) {
                float multiplier = (float)player.m_21133_(Attributes.f_22279_) * 4.0f * (float)level;
                player.m_5997_(player.m_20184_().f_82479_ * (double)multiplier, (double)(0.325f * (float)level), player.m_20184_().f_82481_ * (double)multiplier);
                player.f_19864_ = true;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity != null && event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            Item fromItem = event.getFrom().m_41720_();
            Item toItem = event.getTo().m_41720_();
            if (fromItem instanceof NightGogglesItem) {
                ((NightGogglesItem)fromItem).onDiscard(entity);
            }
            if (fromItem instanceof DragonMageArmorItem) {
                ((DragonMageArmorItem)fromItem).onDiscard(event.getFrom(), entity);
            }
            if (toItem instanceof DragonMageArmorItem) {
                ((DragonMageArmorItem)toItem).onEquip(event.getTo(), entity);
            }
            if (fromItem instanceof DragonMageArmorItem && ((DragonMageArmorItem)fromItem).wouldSetBeEquipped(entity, fromItem)) {
                ((DragonMageArmorItem)fromItem).removeDragonMagicSetBonus(entity);
            }
            if (toItem instanceof DragonMageArmorItem && ((DragonMageArmorItem)toItem).isSetEquipped(entity)) {
                ((DragonMageArmorItem)toItem).applyDragonMagicSetBonus(entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGlideTick(TickEvent.PlayerTickEvent event) {
        ElytraMobEffect.eventHandleElytraFly(event);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ArmorUpgradeHelper.applyOnTickUpgrade(event.player);
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ModMessages.sendToPlayer(new ToggleMajorFireResS2CPacket(ArmorUpgradeHelper.getUpgradeLevel((Player)player, ArmorUpgradeInit.MAJOR_FIRE_RESISTANCE) >= 1), player);
            ModMessages.sendToPlayer(new ToggleBurningFrenzyS2CPacket(ArmorUpgradeHelper.getUpgradeLevel((Player)player, ArmorUpgradeInit.BURNING_FRENZY) >= 1), player);
            ModMessages.sendToPlayer(new ToggleWaterBraceletS2CPacket(!CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, (Item)ItemInit.BRACELET_OF_WATER.get()).isEmpty() || !CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, (Item)ItemInit.BRACELET_OF_WATER_GREATER.get()).isEmpty()), player);
        }
    }
}

