/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.command;

import com.mna.api.faction.IFaction;
import com.mna.factions.Factions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.event.DragonUpgradeEvent;
import de.joh.dmnr.api.item.DragonMageArmorItem;
import de.joh.dmnr.api.item.IDragonMagicContainerItem;
import de.joh.dmnr.common.command.argument.ArmorUpgradeArgument;
import de.joh.dmnr.common.util.Registries;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dmnr", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Commands {
    public Commands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"dmnr").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.addUpgrade())).then(this.changeDragonMageArmor()));
    }

    private ArgumentBuilder<CommandSourceStack, ?> changeDragonMageArmor() {
        return ((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"changeDragonMageArmor").then(this.changeDragonMageArmorTarget((IFaction)Factions.UNDEAD))).then(this.changeDragonMageArmorTarget((IFaction)Factions.DEMONS)).then(this.changeDragonMageArmorTarget((IFaction)Factions.COUNCIL)).then(this.changeDragonMageArmorTarget((IFaction)Factions.FEY));
    }

    private ArgumentBuilder<CommandSourceStack, ?> changeDragonMageArmorTarget(IFaction faction) {
        String factionString = "none";
        if (Factions.DEMONS.equals(faction)) {
            factionString = "demons";
        } else if (Factions.FEY.equals(faction)) {
            factionString = "fey";
        } else if (Factions.COUNCIL.equals(faction)) {
            factionString = "council";
        } else if (Factions.UNDEAD.equals(faction)) {
            factionString = "undead";
        }
        return net.minecraft.commands.Commands.m_82127_((String)factionString).then(net.minecraft.commands.Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(command -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)command, (String)"target");
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (chest.m_41720_() instanceof DragonMageArmorItem && ((DragonMageArmorItem)chest.m_41720_()).isSetEquipped((LivingEntity)player)) {
                DragonUpgradeEvent event = new DragonUpgradeEvent((Player)player, faction);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.canBeUpgraded()) {
                    event.performUpgradeFromDMArmor();
                }
            } else {
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237115_((String)"dmnr.commands.output.changeDragonMageArmorTarget.no.valid.armor.error"), true);
            }
            return 1;
        }));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addUpgrade() {
        return net.minecraft.commands.Commands.m_82127_((String)"addUpgrade").then(net.minecraft.commands.Commands.m_82129_((String)"armor_upgrade", (ArgumentType)new ArmorUpgradeArgument()).then(net.minecraft.commands.Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(net.minecraft.commands.Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            if (!Registries.ARMOR_UPGRADE.get().containsKey(ResourceLocationArgument.m_107011_((CommandContext)command, (String)"armor_upgrade"))) {
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237115_((String)"dmnr.commands.output.callApplyUpgrade.upgradedoesnotexist.error"), true);
            } else {
                ItemStack item = player.m_6844_(EquipmentSlot.MAINHAND);
                if (item.m_41720_() instanceof IDragonMagicContainerItem) {
                    ArmorUpgrade armorUpgrade = (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(ResourceLocationArgument.m_107011_((CommandContext)command, (String)"armor_upgrade"));
                    AtomicInteger level = new AtomicInteger(IntegerArgumentType.getInteger((CommandContext)command, (String)"level"));
                    if (!BoolArgumentType.getBool((CommandContext)command, (String)"force")) {
                        level.set(Math.min(level.get(), armorUpgrade.maxUpgradeLevel));
                    } else if (!armorUpgrade.isInfStackable) {
                        level.set(Math.min(level.get(), armorUpgrade.supportsOnExtraLevel ? armorUpgrade.maxUpgradeLevel + 1 : armorUpgrade.maxUpgradeLevel));
                    }
                    if (((IDragonMagicContainerItem)item.m_41720_()).addDragonMagicToItem(item, armorUpgrade, level.get(), BoolArgumentType.getBool((CommandContext)command, (String)"force"))) {
                        MutableComponent component_one = Component.m_237115_((String)"dmnr.commands.output.callApplyUpgrade.success.one");
                        MutableComponent component_two = Component.m_237115_((String)"dmnr.commands.output.callApplyUpgrade.success.two");
                        ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)(component_one.getString() + armorUpgrade.getRegistryName().toString() + component_two.getString() + level)), true);
                    } else {
                        ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237115_((String)"dmnr.commands.output.callApplyUpgrade.fail.not_enough_space"), true);
                    }
                } else {
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237115_((String)"dmnr.commands.output.callApplyUpgrade.no.armor.equipped.error"), true);
                }
            }
            return 1;
        }))));
    }
}

