/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.armorupgrade;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.entities.utility.MAExplosion;
import de.joh.dmnr.api.armorupgrade.OnTickArmorUpgrade;
import de.joh.dmnr.capabilities.dragonmagic.ArmorUpgradeHelper;
import de.joh.dmnr.common.init.ArmorUpgradeInit;
import de.joh.dmnr.common.util.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class MeteorJumpArmorUpgrade
extends OnTickArmorUpgrade {
    private static final int reqHeight = 4;

    public MeteorJumpArmorUpgrade(@NotNull ResourceLocation registryName, RegistryObject<Item> upgradeSealItem, int upgradeCost) {
        super(registryName, 1, upgradeSealItem, true, upgradeCost);
    }

    @Override
    public void onTick(Level world, Player player, int level, IPlayerMagic magic) {
        if (level > 0 && !player.m_20096_() && player.m_20184_().f_82480_ < 0.0 && !player.m_21255_() && player.m_6047_() && !player.getPersistentData().m_128441_("dmnr_meteor_jumping") && player.m_20142_()) {
            int heightAboveGround;
            BlockPos pos = player.m_20183_();
            for (heightAboveGround = 0; player.m_9236_().m_46859_(pos) && heightAboveGround < 4; ++heightAboveGround) {
                pos = pos.m_7495_();
            }
            if (heightAboveGround >= 4) {
                player.getPersistentData().m_128379_("dmnr_meteor_jumping", true);
                player.m_9236_().m_214150_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SFX.Event.Artifact.METEOR_JUMP, SoundSource.PLAYERS, 0.25f, 0.8f, 0L);
            }
        }
        if (player.getPersistentData().m_128441_("dmnr_meteor_jumping")) {
            if (player.m_20096_()) {
                this.handlePlayerMeteorJumpImpact(player);
            }
            player.m_5997_(0.0, -0.05, 0.0);
            if (player.m_9236_().f_46443_) {
                for (int i = 0; i < 25; ++i) {
                    player.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType)ParticleInit.FLAME.get()), player.m_20185_() - 0.5 + Math.random() * 0.5, player.m_20186_() + Math.random(), player.m_20189_() - 0.5 + Math.random() * 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void handlePlayerMeteorJumpImpact(Player player) {
        if (player.getPersistentData().m_128441_("dmnr_meteor_jumping")) {
            int level = ArmorUpgradeHelper.getUpgradeLevel(player, ArmorUpgradeInit.METEOR_JUMP);
            player.getPersistentData().m_128473_("dmnr_meteor_jumping");
            player.m_6858_(false);
            if (!player.m_9236_().f_46443_) {
                MAExplosion.make((LivingEntity)player, (ServerLevel)((ServerLevel)player.m_9236_()), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (float)((float)((Integer)CommonConfig.METEOR_JUMP_IMPACT.get() * level) / 2.0f), (float)((Integer)CommonConfig.METEOR_JUMP_IMPACT.get() * 3 * level), (boolean)true, (Explosion.BlockInteraction)(GeneralConfigValues.MeteorJumpEnabled && ((ServerLevel)player.m_9236_()).m_7654_().m_129900_().m_46207_(GameRules.f_46132_) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP), (DamageSource)player.m_269291_().m_269036_((Entity)player, null));
            }
        }
    }
}

