/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.armorupgrade;

import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.armorupgrade.OnEquippedArmorUpgrade;
import de.joh.dmnr.common.init.ArmorUpgradeInit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManaBoostArmorUpgrade
extends OnEquippedArmorUpgrade {
    public static final int MINOR_MANA_PER_MANABOOST = 100;
    public static final int MAJOR_MANA_PER_MANABOOST = 250;
    public final boolean isMajor;

    public ManaBoostArmorUpgrade(@NotNull ResourceLocation registryName, RegistryObject<Item> upgradeSealItem, boolean isMajor, int upgradeCost) {
        super(registryName, 4, upgradeSealItem, true, upgradeCost);
        this.isMajor = isMajor;
    }

    @Override
    @Nullable
    public ArmorUpgrade getStrongerAlternative() {
        return this.isMajor ? null : ArmorUpgradeInit.MAJOR_MANA_BOOST;
    }

    @Override
    public void onEquip(Player player, int level) {
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().addModifier("mma_magic_set_bonus" + (this.isMajor ? "1" : ""), (float)((this.isMajor ? 250 : 100) * level)));
    }

    @Override
    public void onRemove(Player player) {
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().removeModifier("mma_magic_set_bonus" + (this.isMajor ? "1" : "")));
    }
}

