/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.armorupgrade;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.armorupgrade.OnTickArmorUpgrade;
import de.joh.dmnr.common.init.ArmorUpgradeInit;
import de.joh.dmnr.common.init.EffectInit;
import de.joh.dmnr.common.util.CommonConfig;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlyArmorUpgrade
extends OnTickArmorUpgrade {
    public FlyArmorUpgrade(@NotNull ResourceLocation registryName, RegistryObject<Item> upgradeSealItem, int upgradeCost) {
        super(registryName, 1, upgradeSealItem, true, upgradeCost);
    }

    @Override
    @Nullable
    public ArmorUpgrade getStrongerAlternative() {
        return ArmorUpgradeInit.ANGEL_FLIGHT;
    }

    @Override
    public void onTick(Level world, Player player, int level, IPlayerMagic magic) {
        if (0 < level && !player.m_21023_((MobEffect)EffectInit.FLY_DISABLED.get())) {
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (player.m_150110_().f_35935_ && !player.m_21023_((MobEffect)com.mna.effects.EffectInit.LEVITATION.get()) && world.f_46443_) {
                    Vec3 look = player.m_20156_().m_82537_(new Vec3(0.0, 1.0, 0.0));
                    float offset = (float)(Math.random() * 0.2);
                    look = look.m_82490_((double)offset);
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType)ParticleInit.ARCANE.get()), player.m_20185_() + look.f_82479_, player.m_20186_(), player.m_20189_() + look.f_82481_, 0.0, -0.05, 0.0);
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType)ParticleInit.ARCANE.get()), player.m_20185_() - look.f_82479_, player.m_20186_(), player.m_20189_() - look.f_82481_, 0.0, -0.05, 0.0);
                }
                ManaAndArtifice.instance.proxy.setFlightEnabled(player, true);
                if (!player.m_7500_() && !player.m_5833_()) {
                    ManaAndArtifice.instance.proxy.setFlySpeed(player, (float)level * CommonConfig.getFlySpeedPerLevel(player));
                    if (!((Boolean)CommonConfig.FLY_ALLOW_SPRTINTING_WHILE_FLYING.get()).booleanValue() && player.m_150110_().f_35935_) {
                        player.m_6858_(false);
                    }
                } else {
                    ManaAndArtifice.instance.proxy.setFlySpeed(player, 0.05f);
                }
            });
        }
    }

    @Override
    public void onRemove(Player player) {
        ManaAndArtifice.instance.proxy.setFlySpeed(player, 0.05f);
        ManaAndArtifice.instance.proxy.setFlightEnabled(player, false);
    }
}

