/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.armorupgrade;

import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.armorupgrade.PotionEffectArmorUpgrade;
import de.joh.dmnr.common.init.ArmorUpgradeInit;
import de.joh.dmnr.common.init.EffectInit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElytraArmorUpgrade
extends PotionEffectArmorUpgrade {
    private final boolean hasStrongerAlternative;

    public ElytraArmorUpgrade(@NotNull ResourceLocation registryName, int maxUpgradeLevel, RegistryObject<Item> upgradeSealItem, boolean hasStrongerAlternative, int upgradeCost) {
        super(registryName, maxUpgradeLevel, upgradeSealItem, !hasStrongerAlternative, upgradeCost);
        this.hasStrongerAlternative = hasStrongerAlternative;
    }

    @Override
    @Nullable
    public ArmorUpgrade getStrongerAlternative() {
        return this.hasStrongerAlternative ? ArmorUpgradeInit.ANGEL_FLIGHT : null;
    }

    @Override
    @NotNull
    public MobEffect getMobEffect() {
        return (MobEffect)EffectInit.ELYTRA.get();
    }

    @Override
    public void applyPotionAffect(Player player, int level) {
        if (this.hasStrongerAlternative()) {
            if (!player.m_21023_(this.getMobEffect())) {
                player.m_7292_(new MobEffectInstance(this.getMobEffect(), -1, 0, false, false, false));
            } else {
                player.m_21124_(this.getMobEffect()).m_19558_(new MobEffectInstance(this.getMobEffect(), -1, 0, false, false, false));
            }
        } else {
            super.applyPotionAffect(player, level + 1);
        }
    }
}

