/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.common.armorupgrade;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.sound.SFX;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.IDelayedEvent;
import com.mna.api.timing.TimedDelayedEvent;
import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.armorupgrade.IOnEquippedArmorUpgrade;
import de.joh.dmnr.api.armorupgrade.OnTickArmorUpgrade;
import de.joh.dmnr.networking.ModMessages;
import de.joh.dmnr.networking.packet.ToggleBurningFrenzyS2CPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BurningFrenzyArmorUpgrade
extends OnTickArmorUpgrade
implements IOnEquippedArmorUpgrade {
    public static final AttributeModifier runSpeed_1 = new AttributeModifier("dmnr_armor_burning_frenzy_1", 0.05, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier runSpeed_2 = new AttributeModifier("dmnr_armor_burning_frenzy_2", 0.1, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier runSpeed_3 = new AttributeModifier("dmnr_armor_burning_frenzy_3", 0.1, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier runSpeed_4 = new AttributeModifier("dmnr_armor_burning_frenzy_4", 0.1, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier runSpeed_5 = new AttributeModifier("dmnr_armor_burning_frenzy_5", 0.1, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier stepMod1 = new AttributeModifier("dmnr_armor_burning_frenzy_step_bonus_1", 0.5, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier stepMod2 = new AttributeModifier("dmnr_armor_burning_frenzy_step_bonus_2", 0.5, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier stepMod3 = new AttributeModifier("dmnr_armor_burning_frenzy_step_bonus_3", 0.5, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier stepMod4 = new AttributeModifier("dmnr_armor_burning_frenzy_step_bonus_4", 0.5, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier stepMod5 = new AttributeModifier("dmnr_armor_burning_frenzy_step_bonus_5", 0.5, AttributeModifier.Operation.ADDITION);

    public BurningFrenzyArmorUpgrade(@NotNull ResourceLocation registryName, RegistryObject<Item> upgradeSealItem, int upgradeCost) {
        super(registryName, 1, upgradeSealItem, false, true, upgradeCost);
    }

    @Override
    public void onTick(Level world, Player player, int level, IPlayerMagic magic) {
        if (player.m_20142_() && magic.getCastingResource().hasEnoughAbsolute((LivingEntity)player, 0.07f)) {
            if (!player.m_21051_(Attributes.f_22279_).m_22109_(runSpeed_1)) {
                player.m_21051_(Attributes.f_22279_).m_22118_(runSpeed_1);
                player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22118_(stepMod1);
                DelayedEventQueue.pushEvent((Level)world, (IDelayedEvent)new TimedDelayedEvent("dmnr_armor_burning_frenzy_2", 60, (Object)player, this::addDelayedRunSpeed));
                DelayedEventQueue.pushEvent((Level)world, (IDelayedEvent)new TimedDelayedEvent("dmnr_armor_burning_frenzy_3", 120, (Object)player, this::addDelayedRunSpeed));
                if (level > 1) {
                    DelayedEventQueue.pushEvent((Level)world, (IDelayedEvent)new TimedDelayedEvent("dmnr_armor_burning_frenzy_4", 180, (Object)player, this::addDelayedRunSpeed));
                    DelayedEventQueue.pushEvent((Level)world, (IDelayedEvent)new TimedDelayedEvent("dmnr_armor_burning_frenzy_5", 240, (Object)player, this::addDelayedRunSpeed));
                }
                player.m_9236_().m_214150_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SFX.Event.Artifact.DEMON_ARMOR_SPRINT_START, SoundSource.PLAYERS, 1.0f, 0.8f, 0L);
            }
            magic.getCastingResource().consume((LivingEntity)player, 0.07f);
        } else {
            player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_1);
            player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_2);
            player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_3);
            player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_4);
            player.m_21051_(Attributes.f_22279_).m_22130_(runSpeed_5);
            player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22130_(stepMod1);
            player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22130_(stepMod2);
            player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22130_(stepMod3);
            player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22130_(stepMod4);
            player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22130_(stepMod5);
        }
    }

    public void addDelayedRunSpeed(String identifier, Player player) {
        if (player.m_20142_()) {
            if (identifier.equals("dmnr_armor_burning_frenzy_2") && !player.m_21051_(Attributes.f_22279_).m_22109_(runSpeed_2)) {
                player.m_21051_(Attributes.f_22279_).m_22118_(runSpeed_2);
                player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22118_(stepMod2);
                player.m_9236_().m_214150_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SFX.Event.Artifact.DEMON_ARMOR_SPRINT_START, SoundSource.PLAYERS, 1.0f, 1.0f, 0L);
            } else if (identifier.equals("dmnr_armor_burning_frenzy_3") && !player.m_21051_(Attributes.f_22279_).m_22109_(runSpeed_3)) {
                player.m_21051_(Attributes.f_22279_).m_22118_(runSpeed_3);
                player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22118_(stepMod3);
                player.m_9236_().m_214150_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SFX.Event.Artifact.DEMON_ARMOR_SPRINT_START, SoundSource.PLAYERS, 1.0f, 1.2f, 0L);
            } else if (identifier.equals("dmnr_armor_burning_frenzy_4") && !player.m_21051_(Attributes.f_22279_).m_22109_(runSpeed_4)) {
                player.m_21051_(Attributes.f_22279_).m_22118_(runSpeed_4);
                player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22118_(stepMod4);
                player.m_9236_().m_214150_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SFX.Event.Artifact.DEMON_ARMOR_SPRINT_START, SoundSource.PLAYERS, 1.0f, 1.4f, 0L);
            } else if (identifier.equals("dmnr_armor_burning_frenzy_5") && !player.m_21051_(Attributes.f_22279_).m_22109_(runSpeed_5)) {
                player.m_21051_(Attributes.f_22279_).m_22118_(runSpeed_5);
                player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22118_(stepMod5);
                player.m_9236_().m_214150_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SFX.Event.Artifact.DEMON_ARMOR_SPRINT_START, SoundSource.PLAYERS, 1.0f, 1.6f, 0L);
            }
        }
    }

    @Override
    public void onEquip(Player player, int level) {
        if (!this.hasStrongerAlternative() && level >= 1 && player instanceof ServerPlayer) {
            ModMessages.sendToPlayer(new ToggleBurningFrenzyS2CPacket(true), (ServerPlayer)player);
        }
    }

    @Override
    public void onRemove(Player player) {
        if (!this.hasStrongerAlternative() && player instanceof ServerPlayer) {
            ModMessages.sendToPlayer(new ToggleBurningFrenzyS2CPacket(false), (ServerPlayer)player);
        }
    }

    @Override
    public ArmorUpgrade getArmorUpgrade() {
        return this;
    }
}

