/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.client.event;

import de.joh.dmnr.capabilities.client.ClientPlayerDragonMagic;
import de.joh.dmnr.client.item.armor.WingRenderLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dmnr", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerRenderHandler {
    private static final float FOG_AMOUNT = 0.0f;
    private static boolean addedDragonWingLayer = false;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        if (!addedDragonWingLayer) {
            event.getRenderer().m_115326_(new WingRenderLayer(event.getRenderer(), Minecraft.m_91087_().m_167973_()));
            addedDragonWingLayer = true;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderOverlay(RenderBlockScreenEffectEvent event) {
        if (event.getBlockState().m_60734_() == Blocks.f_50083_ && ClientPlayerDragonMagic.hasMajorFireResistance()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onFogRenderEvent(ViewportEvent.RenderFog event) {
        if (event.getCamera().m_167685_() == FogType.LAVA && ClientPlayerDragonMagic.hasMajorFireResistance()) {
            event.setNearPlaneDistance(-8.0f);
            event.setFarPlaneDistance(192.0f);
            event.setCanceled(true);
        }
        if (event.getCamera().m_167685_() == FogType.WATER && ClientPlayerDragonMagic.hasWaterBracelet()) {
            event.setNearPlaneDistance(-8.0f);
            event.setFarPlaneDistance(192.0f);
            event.setCanceled(true);
        }
    }
}

