/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.capabilities.dragonmagic;

import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.armorupgrade.IOnEquippedArmorUpgrade;
import de.joh.dmnr.api.armorupgrade.OnTickArmorUpgrade;
import de.joh.dmnr.api.util.MarkSave;
import de.joh.dmnr.common.util.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import oshi.util.tuples.Pair;

public class PlayerDragonMagic {
    protected HashMap<String, Pair<ArmorUpgrade, Integer>> onEventUpgrade = new HashMap();
    protected HashMap<String, Pair<OnTickArmorUpgrade, Integer>> onTickUpgrade = new HashMap();
    protected HashMap<String, Pair<ArmorUpgrade, Integer>> onEventPermaUpgrade = new HashMap();
    protected HashMap<String, Pair<OnTickArmorUpgrade, Integer>> onTickPermaUpgrade = new HashMap();
    private HashMap<ResourceKey<Level>, MarkSave> markMap = new HashMap();

    public void mark(BlockPos position, Direction direction, Level world) {
        this.markMap.put((ResourceKey<Level>)world.m_46472_(), new MarkSave(position, direction));
    }

    public boolean hasValidMark(Level world) {
        return this.markMap.get(world.m_46472_()) != null;
    }

    @Nullable
    public MarkSave getMark(Level world) {
        return this.markMap.get(world.m_46472_());
    }

    public void copyFrom(PlayerDragonMagic source, Player player) {
        this.markMap = source.getMarkMap();
        for (Map.Entry<String, Pair<ArmorUpgrade, Integer>> entry : this.onEventUpgrade.entrySet()) {
            this.addUpgrade(entry.getKey(), (ArmorUpgrade)entry.getValue().getA(), (int)((Integer)entry.getValue().getB()), player);
        }
        for (Map.Entry<String, Pair<ArmorUpgrade, Integer>> entry : this.onTickUpgrade.entrySet()) {
            this.addUpgrade(entry.getKey(), (ArmorUpgrade)entry.getValue().getA(), (int)((Integer)entry.getValue().getB()), player);
        }
    }

    public HashMap<ResourceKey<Level>, MarkSave> getMarkMap() {
        return this.markMap;
    }

    /*
     * WARNING - void declaration
     */
    public void saveNBT(CompoundTag compound) {
        CompoundTag nbt = new CompoundTag();
        int upgradeSize = 0;
        for (Map.Entry<String, Pair<ArmorUpgrade, Integer>> entry : this.onEventUpgrade.entrySet()) {
            nbt.m_128359_("upgrade_source_" + upgradeSize, entry.getKey());
            nbt.m_128359_("upgrade_value_" + upgradeSize, ((ArmorUpgrade)entry.getValue().getA()).getRegistryName().toString());
            nbt.m_128405_("upgrade_int_" + upgradeSize, ((Integer)entry.getValue().getB()).intValue());
            ++upgradeSize;
        }
        for (Map.Entry<String, Pair<ArmorUpgrade, Integer>> entry : this.onTickUpgrade.entrySet()) {
            nbt.m_128359_("upgrade_source_" + upgradeSize, entry.getKey());
            nbt.m_128359_("upgrade_value_" + upgradeSize, ((OnTickArmorUpgrade)entry.getValue().getA()).getRegistryName().toString());
            nbt.m_128405_("upgrade_int_" + upgradeSize, ((Integer)entry.getValue().getB()).intValue());
            ++upgradeSize;
        }
        nbt.m_128405_("upgrades_size", upgradeSize);
        int upgradePermaSize = 0;
        for (Map.Entry<String, Pair<ArmorUpgrade, Integer>> entry : this.onEventPermaUpgrade.entrySet()) {
            nbt.m_128359_("perma_upgrade_source_" + upgradePermaSize, entry.getKey());
            nbt.m_128359_("perma_upgrade_value_" + upgradePermaSize, ((ArmorUpgrade)entry.getValue().getA()).getRegistryName().toString());
            nbt.m_128405_("perma_upgrade_int_" + upgradePermaSize, ((Integer)entry.getValue().getB()).intValue());
            ++upgradePermaSize;
        }
        for (Map.Entry<String, Pair<OnTickArmorUpgrade, Integer>> entry : this.onTickPermaUpgrade.entrySet()) {
            nbt.m_128359_("perma_upgrade_source_" + upgradePermaSize, entry.getKey());
            nbt.m_128359_("perma_upgrade_value_" + upgradePermaSize, ((OnTickArmorUpgrade)entry.getValue().getA()).getRegistryName().toString());
            nbt.m_128405_("perma_upgrade_int_" + upgradePermaSize, ((Integer)entry.getValue().getB()).intValue());
            ++upgradePermaSize;
        }
        nbt.m_128405_("perma_upgrades_size", upgradePermaSize);
        nbt.m_128405_("mark_map_size", this.markMap.size());
        boolean bl = false;
        for (Map.Entry<ResourceKey<Level>, MarkSave> entry : this.markMap.entrySet()) {
            void var5_12;
            nbt.m_128359_("mark_map_dimension_" + (int)var5_12, entry.getKey().m_135782_().toString());
            nbt.m_128365_("mark_map_mark_save_" + (int)var5_12, (Tag)entry.getValue().saveNBT());
            ++var5_12;
        }
        compound.m_128365_("dragon_magic_data", (Tag)nbt);
    }

    public void loadNBT(CompoundTag compound) {
        if (compound.m_128441_("dragon_magic_data")) {
            int i;
            CompoundTag nbt = compound.m_128469_("dragon_magic_data");
            for (i = 0; i < nbt.m_128451_("upgrades_size"); ++i) {
                this.addUpgrade(nbt.m_128461_("upgrade_source_" + i), (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(new ResourceLocation(nbt.m_128461_("upgrade_value_" + i))), nbt.m_128451_("upgrade_int_" + i), false);
            }
            for (i = 0; i < nbt.m_128451_("perma_upgrades_size"); ++i) {
                this.addUpgrade(nbt.m_128461_("perma_upgrade_source_" + i), (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(new ResourceLocation(nbt.m_128461_("perma_upgrade_value_" + i))), nbt.m_128451_("perma_upgrade_int_" + i), true);
            }
            if (nbt.m_128441_("mark_map_size")) {
                for (i = 0; i < nbt.m_128451_("mark_map_size"); ++i) {
                    this.markMap.put((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)net.minecraft.core.registries.Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("mark_map_dimension_" + i))), new MarkSave(nbt.m_128469_("mark_map_mark_save_" + i)));
                }
            }
        }
    }

    public void addUpgrade(String source, @Nullable ArmorUpgrade armorUpgrade, int level, Player player) {
        this.addUpgrade(source, armorUpgrade, level, player, false);
    }

    public void addUpgrade(String source, @Nullable ArmorUpgrade armorUpgrade, int level, Player player, boolean isPermaUpgrade) {
        if (armorUpgrade != null) {
            this.addUpgrade(source, armorUpgrade, level, isPermaUpgrade);
        }
    }

    public void removeUpgrade(String source, Player player) {
        Pair<ArmorUpgrade, Integer> armorUpgrade5;
        Pair<OnTickArmorUpgrade, Integer> armorUpgrade3;
        Pair<ArmorUpgrade, Integer> armorUpgrade2;
        Pair<OnTickArmorUpgrade, Integer> armorUpgrade0 = this.onTickUpgrade.remove(source);
        if (armorUpgrade0 != null) {
            ((OnTickArmorUpgrade)armorUpgrade0.getA()).onRemove(player);
        }
        if ((armorUpgrade2 = this.onEventUpgrade.remove(source)) != null) {
            ((ArmorUpgrade)armorUpgrade2.getA()).onRemove(player);
        }
        if ((armorUpgrade3 = this.onTickPermaUpgrade.remove(source)) != null) {
            ((OnTickArmorUpgrade)armorUpgrade3.getA()).onRemove(player);
        }
        if ((armorUpgrade5 = this.onEventPermaUpgrade.remove(source)) != null) {
            ((ArmorUpgrade)armorUpgrade5.getA()).onRemove(player);
        }
    }

    private void addUpgrade(String source, @Nullable ArmorUpgrade armorUpgrade, int level, boolean isPermaUpgrade) {
        if (!isPermaUpgrade) {
            if (armorUpgrade instanceof OnTickArmorUpgrade) {
                this.onTickUpgrade.put(source, (Pair<OnTickArmorUpgrade, Integer>)new Pair((Object)((OnTickArmorUpgrade)armorUpgrade), (Object)level));
            } else if (armorUpgrade != null) {
                this.onEventUpgrade.put(source, (Pair<ArmorUpgrade, Integer>)new Pair((Object)armorUpgrade, (Object)level));
            }
        } else if (armorUpgrade instanceof OnTickArmorUpgrade) {
            this.onTickPermaUpgrade.put(source, (Pair<OnTickArmorUpgrade, Integer>)new Pair((Object)((OnTickArmorUpgrade)armorUpgrade), (Object)level));
        } else if (armorUpgrade != null) {
            this.onEventPermaUpgrade.put(source, (Pair<ArmorUpgrade, Integer>)new Pair((Object)armorUpgrade, (Object)level));
        }
    }

    public ArrayList<Pair<IOnEquippedArmorUpgrade, Integer>> getAllOnEquipPermaUpgrade() {
        ArrayList<Pair<IOnEquippedArmorUpgrade, Integer>> ret = new ArrayList<Pair<IOnEquippedArmorUpgrade, Integer>>();
        for (Pair<ArmorUpgrade, Integer> pair : this.onEventPermaUpgrade.values()) {
            if (!(pair.getA() instanceof IOnEquippedArmorUpgrade)) continue;
            ret.add((Pair<IOnEquippedArmorUpgrade, Integer>)new Pair((Object)((IOnEquippedArmorUpgrade)pair.getA()), (Object)((Integer)pair.getB())));
        }
        for (Pair<ArmorUpgrade, Integer> pair : this.onTickPermaUpgrade.values()) {
            if (!(pair.getA() instanceof IOnEquippedArmorUpgrade)) continue;
            ret.add((Pair<IOnEquippedArmorUpgrade, Integer>)new Pair((Object)((IOnEquippedArmorUpgrade)pair.getA()), (Object)((Integer)pair.getB())));
        }
        return ret;
    }

    public ArrayList<Pair<IOnEquippedArmorUpgrade, Integer>> getAllOnEquipUpgrade() {
        ArrayList<Pair<IOnEquippedArmorUpgrade, Integer>> ret = new ArrayList<Pair<IOnEquippedArmorUpgrade, Integer>>();
        for (Pair<ArmorUpgrade, Integer> pair : this.onEventUpgrade.values()) {
            if (!(pair.getA() instanceof IOnEquippedArmorUpgrade)) continue;
            ret.add((Pair<IOnEquippedArmorUpgrade, Integer>)new Pair((Object)((IOnEquippedArmorUpgrade)pair.getA()), (Object)((Integer)pair.getB())));
        }
        for (Pair<ArmorUpgrade, Integer> pair : this.onTickUpgrade.values()) {
            if (!(pair.getA() instanceof IOnEquippedArmorUpgrade)) continue;
            ret.add((Pair<IOnEquippedArmorUpgrade, Integer>)new Pair((Object)((IOnEquippedArmorUpgrade)pair.getA()), (Object)((Integer)pair.getB())));
        }
        return ret;
    }
}

