/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.capabilities.dragonmagic;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.armorupgrade.IOnEquippedArmorUpgrade;
import de.joh.dmnr.api.armorupgrade.OnTickArmorUpgrade;
import de.joh.dmnr.api.item.DragonMageArmorItem;
import de.joh.dmnr.capabilities.dragonmagic.PlayerDragonMagicProvider;
import de.joh.dmnr.common.init.EffectInit;
import de.joh.dmnr.common.util.Registries;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class ArmorUpgradeHelper {
    public static int getUpgradeLevel(@NotNull Player player, @NotNull ArmorUpgrade armorUpgrade) {
        DragonMageArmorItem dragonMageArmor;
        Item item;
        if (armorUpgrade.getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, armorUpgrade.getStrongerAlternative()) > 0) {
            return 0;
        }
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        AtomicInteger level = new AtomicInteger(0);
        if (!chest.m_41619_() && (item = chest.m_41720_()) instanceof DragonMageArmorItem && (dragonMageArmor = (DragonMageArmorItem)item).isSetEquipped((LivingEntity)player)) {
            if (player.m_21023_((MobEffect)EffectInit.ULTIMATE_ARMOR.get())) {
                return armorUpgrade.maxUpgradeLevel;
            }
            player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
                if (armorUpgrade instanceof OnTickArmorUpgrade) {
                    for (Pair<OnTickArmorUpgrade, Integer> equippedAU : playerCapability.onTickUpgrade.values()) {
                        if (!armorUpgrade.equals(equippedAU.getA())) continue;
                        level.set(Math.max(level.get(), (Integer)equippedAU.getB()));
                    }
                } else {
                    for (Pair<ArmorUpgrade, Integer> equippedAU : playerCapability.onEventUpgrade.values()) {
                        if (!armorUpgrade.equals(equippedAU.getA())) continue;
                        level.set(Math.max(level.get(), (Integer)equippedAU.getB()));
                    }
                }
            });
        }
        player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
            if (armorUpgrade instanceof OnTickArmorUpgrade) {
                for (Pair<OnTickArmorUpgrade, Integer> equippedAU : playerCapability.onTickPermaUpgrade.values()) {
                    if (!armorUpgrade.equals(equippedAU.getA())) continue;
                    level.set(Math.max(level.get(), (Integer)equippedAU.getB()));
                }
            } else {
                for (Pair<ArmorUpgrade, Integer> equippedAU : playerCapability.onEventPermaUpgrade.values()) {
                    if (!armorUpgrade.equals(equippedAU.getA())) continue;
                    level.set(Math.max(level.get(), (Integer)equippedAU.getB()));
                }
            }
        });
        return level.get();
    }

    public static void applyOnTickUpgrade(Player player) {
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        HashMap toApply = new HashMap();
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
            DragonMageArmorItem dragonMageArmor;
            Object patt3641$temp;
            if (!chest.m_41619_() && (patt3641$temp = chest.m_41720_()) instanceof DragonMageArmorItem && (dragonMageArmor = (DragonMageArmorItem)patt3641$temp).isSetEquipped((LivingEntity)player)) {
                if (player.m_21023_((MobEffect)EffectInit.ULTIMATE_ARMOR.get())) {
                    for (ArmorUpgrade armorUpgrade : Registries.ARMOR_UPGRADE.get().getValues()) {
                        if (!(armorUpgrade instanceof OnTickArmorUpgrade) || armorUpgrade.hasStrongerAlternative()) continue;
                        ((OnTickArmorUpgrade)armorUpgrade).onTick(player.m_9236_(), player, armorUpgrade.maxUpgradeLevel, (IPlayerMagic)magic);
                    }
                    return;
                }
                player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
                    for (Pair<OnTickArmorUpgrade, Integer> pair : playerCapability.onTickUpgrade.values()) {
                        if ((Integer)pair.getB() <= 0) continue;
                        toApply.put((OnTickArmorUpgrade)pair.getA(), Math.max((Integer)pair.getB(), toApply.getOrDefault(pair.getA(), 0)));
                    }
                });
            }
            player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
                for (Pair<OnTickArmorUpgrade, Integer> pair : playerCapability.onTickPermaUpgrade.values()) {
                    if ((Integer)pair.getB() <= 0) continue;
                    toApply.put((OnTickArmorUpgrade)pair.getA(), Math.max((Integer)pair.getB(), toApply.getOrDefault(pair.getA(), 0)));
                }
            });
            for (Map.Entry entry : toApply.entrySet()) {
                if (((OnTickArmorUpgrade)entry.getKey()).getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, ((OnTickArmorUpgrade)entry.getKey()).getStrongerAlternative()) != 0) continue;
                ((OnTickArmorUpgrade)entry.getKey()).onTick(player.m_9236_(), player, (Integer)entry.getValue(), (IPlayerMagic)magic);
            }
        });
    }

    public static void deactivateAll(Player player) {
        ArmorUpgradeHelper.deactivateAll(player, true);
    }

    public static void deactivateAll(Player player, boolean alsoPerma) {
        player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
            for (Pair<ArmorUpgrade, Integer> pair : playerCapability.onEventUpgrade.values()) {
                if (((ArmorUpgrade)pair.getA()).getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, ((ArmorUpgrade)pair.getA()).getStrongerAlternative()) != 0) continue;
                ((ArmorUpgrade)pair.getA()).onRemove(player);
            }
            for (Pair pair : playerCapability.getAllOnEquipUpgrade()) {
                if (((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, ((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().getStrongerAlternative()) != 0) continue;
                ((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().onRemove(player);
            }
            for (Pair pair : playerCapability.onTickUpgrade.values()) {
                if (((OnTickArmorUpgrade)pair.getA()).getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, ((OnTickArmorUpgrade)pair.getA()).getStrongerAlternative()) != 0) continue;
                ((OnTickArmorUpgrade)pair.getA()).onRemove(player);
            }
        });
        if (alsoPerma) {
            ArmorUpgradeHelper.deactivateAllPerma(player, false);
            ArmorUpgradeHelper.activateOnEquipPerma(player);
        }
    }

    public static void deactivateAllPerma(Player player) {
        ArmorUpgradeHelper.deactivateAllPerma(player, true);
    }

    public static void deactivateAllPerma(Player player, boolean alsoNormal) {
        DragonMageArmorItem dragonMageArmor;
        Item item;
        player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
            for (Pair<ArmorUpgrade, Integer> pair : playerCapability.onEventPermaUpgrade.values()) {
                if (((ArmorUpgrade)pair.getA()).getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, ((ArmorUpgrade)pair.getA()).getStrongerAlternative()) != 0) continue;
                ((ArmorUpgrade)pair.getA()).onRemove(player);
            }
            for (Pair pair : playerCapability.getAllOnEquipPermaUpgrade()) {
                if (((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, ((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().getStrongerAlternative()) != 0) continue;
                ((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().onRemove(player);
            }
            for (Pair pair : playerCapability.onTickPermaUpgrade.values()) {
                if (((OnTickArmorUpgrade)pair.getA()).getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, ((OnTickArmorUpgrade)pair.getA()).getStrongerAlternative()) != 0) continue;
                ((OnTickArmorUpgrade)pair.getA()).onRemove(player);
            }
        });
        if (alsoNormal && (item = player.m_6844_(EquipmentSlot.CHEST).m_41720_()) instanceof DragonMageArmorItem && (dragonMageArmor = (DragonMageArmorItem)item).isSetEquipped((LivingEntity)player)) {
            ArmorUpgradeHelper.deactivateAll(player, false);
            ArmorUpgradeHelper.activateOnEquip(player);
        }
    }

    public static void activateOnEquipPerma(Player player) {
        player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
            for (Pair<IOnEquippedArmorUpgrade, Integer> pair : playerCapability.getAllOnEquipPermaUpgrade()) {
                if (((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, ((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().getStrongerAlternative()) != 0) continue;
                ((IOnEquippedArmorUpgrade)pair.getA()).onEquip(player, ArmorUpgradeHelper.getUpgradeLevel(player, ((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade()));
            }
        });
    }

    public static void activateOnEquip(Player player) {
        DragonMageArmorItem dma;
        Item item = player.m_6844_(EquipmentSlot.CHEST).m_41720_();
        if (item instanceof DragonMageArmorItem && (dma = (DragonMageArmorItem)item).isSetEquipped((LivingEntity)player)) {
            player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
                for (Pair<IOnEquippedArmorUpgrade, Integer> pair : playerCapability.getAllOnEquipUpgrade()) {
                    if (((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().getStrongerAlternative() != null && ArmorUpgradeHelper.getUpgradeLevel(player, ((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade().getStrongerAlternative()) != 0) continue;
                    ((IOnEquippedArmorUpgrade)pair.getA()).onEquip(player, ArmorUpgradeHelper.getUpgradeLevel(player, ((IOnEquippedArmorUpgrade)pair.getA()).getArmorUpgrade()));
                }
            });
        }
    }

    public static void ultimateArmorStart(Player player) {
        DragonMageArmorItem dma;
        ArmorUpgradeHelper.deactivateAll(player);
        ArmorUpgradeHelper.deactivateAllPerma(player);
        Item item = player.m_6844_(EquipmentSlot.CHEST).m_41720_();
        if (item instanceof DragonMageArmorItem && (dma = (DragonMageArmorItem)item).isSetEquipped((LivingEntity)player)) {
            for (ArmorUpgrade armorUpgrade : Registries.ARMOR_UPGRADE.get().getValues()) {
                if (!(armorUpgrade instanceof IOnEquippedArmorUpgrade)) continue;
                ((IOnEquippedArmorUpgrade)((Object)armorUpgrade)).onEquip(player, armorUpgrade.maxUpgradeLevel);
            }
        }
    }

    public static void ultimateArmorFin(Player player) {
        for (ArmorUpgrade armorUpgrade : Registries.ARMOR_UPGRADE.get().getValues()) {
            armorUpgrade.onRemove(player);
        }
        ArmorUpgradeHelper.activateOnEquipPerma(player);
        ArmorUpgradeHelper.activateOnEquip(player);
    }
}

