/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.api.util;

import de.joh.dmnr.common.util.RLoc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.Nullable;

public class ModTags {
    public static List<Item> getItemTagContents(ResourceLocation tagID) {
        try {
            ITag tag = ForgeRegistries.ITEMS.tags().getTag(ForgeRegistries.ITEMS.tags().createTagKey(tagID));
            if (tag != null) {
                return tag.stream().collect(Collectors.toList());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<Item>();
    }

    public static List<Block> getBlockTagContents(ResourceLocation tagID) {
        try {
            ITag tag = ForgeRegistries.BLOCKS.tags().getTag(ForgeRegistries.BLOCKS.tags().createTagKey(tagID));
            if (tag != null) {
                return tag.stream().collect(Collectors.toList());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<Block>();
    }

    @Nullable
    public static Block getRandomBlock(ResourceLocation tag) {
        try {
            Random random = new Random();
            List<Block> list = ModTags.getBlockTagContents(tag);
            return list.get(random.nextInt(list.size()));
        }
        catch (Exception var3) {
            return null;
        }
    }

    @Nullable
    public static Item getRandomItem(ResourceLocation tag) {
        try {
            Random random = new Random();
            List<Item> list = ModTags.getItemTagContents(tag);
            return list.get(random.nextInt(list.size()));
        }
        catch (Exception var3) {
            return null;
        }
    }

    public static boolean isBlockIn(Block block, ResourceLocation tag) {
        try {
            return ModTags.getBlockTagContents(tag).contains(block);
        }
        catch (Exception var3) {
            return false;
        }
    }

    public static boolean isItemIn(Item item, ResourceLocation tag) {
        try {
            return ModTags.getItemTagContents(tag).contains(item);
        }
        catch (Exception var3) {
            return false;
        }
    }

    public static class Items {
        public static ResourceLocation UPGRADE_SEAL_TIER = RLoc.create("upgrade_seal_tier");
        public static ResourceLocation DRAGON_MAGIC_CONTAINER = RLoc.create("dragon_magic_container");
        public static ResourceLocation MNA_ARTIFACT = RLoc.create("mna_artifact");
    }

    public static class Blocks {
        public static ResourceLocation TALL_FLOWERS = new ResourceLocation("minecraft", "tall_flowers");
        public static ResourceLocation MUTANDIS_PLANTS = RLoc.create("mutandis_plants");
        public static ResourceLocation MNA_FLOWERS = RLoc.create("mna_flowers");
    }
}

