/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.api.util;

import com.mna.api.items.IPositionalItem;
import com.mna.items.ItemInit;
import com.mna.items.ritual.PlayerCharm;
import de.joh.dmnr.capabilities.dragonmagic.PlayerDragonMagicProvider;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MarkSave {
    private BlockPos position;
    private Direction direction;

    public MarkSave(BlockPos position, Direction direction) {
        this.position = position;
        this.direction = direction;
    }

    public MarkSave(CompoundTag nbt) {
        if (nbt.m_128441_("x") && nbt.m_128441_("y") && nbt.m_128441_("z") && nbt.m_128441_("direction")) {
            this.position = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
            this.direction = Direction.m_122402_((String)nbt.m_128461_("direction"));
        }
    }

    @Nullable
    public BlockPos getPosition() {
        return this.position;
    }

    @Nullable
    public Direction getDirection() {
        return this.direction;
    }

    public CompoundTag saveNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("x", this.position.m_123341_());
        nbt.m_128405_("y", this.position.m_123342_());
        nbt.m_128405_("z", this.position.m_123343_());
        nbt.m_128359_("direction", this.direction.m_122433_());
        return nbt;
    }

    @Nullable
    public static MarkSave getMark(@NotNull LivingEntity source, @NotNull Level world) {
        return MarkSave.getMark(source, world, false);
    }

    @Nullable
    public static MarkSave getMark(@NotNull LivingEntity source, @NotNull Level world, boolean allowPlayerCharm) {
        ItemStack playerCharm;
        ItemStack markingRune;
        ItemStack itemStack = markingRune = source.m_21205_().m_41720_() != ItemInit.RUNE_MARKING.get() && source.m_21205_().m_41720_() != ItemInit.BOOK_MARKS.get() ? source.m_21206_() : source.m_21205_();
        if (markingRune.m_41720_() instanceof IPositionalItem) {
            return new MarkSave(((IPositionalItem)markingRune.m_41720_()).getLocation(markingRune), ((IPositionalItem)markingRune.m_41720_()).getFace(markingRune));
        }
        ItemStack itemStack2 = playerCharm = source.m_21205_().m_41720_() != ItemInit.PLAYER_CHARM.get() ? source.m_21206_() : source.m_21205_();
        if (allowPlayerCharm && playerCharm.m_41720_() instanceof PlayerCharm) {
            Player target = ((PlayerCharm)playerCharm.m_41720_()).GetPlayerTarget(playerCharm, world);
            if (target != null && target.m_9236_().m_46472_() == source.m_9236_().m_46472_()) {
                return new MarkSave(target.m_20183_().m_6630_(-1), Direction.UP);
            }
            return null;
        }
        if (source instanceof Player) {
            AtomicReference<Object> playerMark = new AtomicReference<Object>(null);
            source.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(magic -> {
                if (magic.hasValidMark(world)) {
                    playerMark.set(magic.getMark(world));
                }
            });
            return playerMark.get();
        }
        return null;
    }
}

