/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.api.spell.component;

import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import de.joh.dmnr.common.util.CommonConfig;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;

public abstract class ConjureFluidComponent
extends SpellEffect {
    private final FluidStack fluidStack;

    public ConjureFluidComponent(ResourceLocation guiIcon, Fluid fluid, AttributeValuePair ... attributeValuePairs) {
        super(guiIcon, attributeValuePairs);
        this.fluidStack = new FluidStack(fluid, 1000);
    }

    public Fluid getFluid() {
        return this.fluidStack.getFluid();
    }

    public boolean targetsEntities() {
        return false;
    }

    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        Level world = source.getCaster().m_20193_();
        if (!target.isBlock()) {
            return ComponentApplicationResult.FAIL;
        }
        if (!world.f_46443_) {
            boolean result;
            boolean result2;
            Block block = world.m_8055_(target.getBlock()).m_60734_();
            if (this.getCauldronType() != null && (block == Blocks.f_50256_ || block == this.getCauldronType())) {
                world.m_46597_(target.getBlock(), this.getCauldronBlockState());
                return ComponentApplicationResult.SUCCESS;
            }
            IFluidHandler destination = this.getFluidHandler(world, target.getBlock(), null);
            if (destination != null && this.tryInsertFluid(destination, false) && (result2 = this.tryInsertFluid(destination, true))) {
                return ComponentApplicationResult.SUCCESS;
            }
            IFluidHandler destinationSide = this.getFluidHandler(world, target.getBlock(), target.getBlockFace(null));
            if (destinationSide != null && this.tryInsertFluid(destinationSide, false) && (result = this.tryInsertFluid(destinationSide, true))) {
                return ComponentApplicationResult.SUCCESS;
            }
            if (destination == null && destinationSide == null) {
                Player player;
                LivingEntity livingEntity;
                BlockPos targetPos = target.getBlock().m_121945_(target.getBlockFace(null));
                boolean isDestNonSolid = !world.m_8055_(targetPos).m_280296_();
                boolean isEmpty = world.m_46859_(targetPos);
                if ((isDestNonSolid || isEmpty) && (livingEntity = source.getCaster()) instanceof Player && this.tryPlaceFluid(player = (Player)livingEntity, world, targetPos, modificationData, false)) {
                    return ComponentApplicationResult.SUCCESS;
                }
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }

    @Nullable
    public Block getCauldronType() {
        return null;
    }

    @Nullable
    public BlockState getCauldronBlockState() {
        return this.getCauldronType() != null ? this.getCauldronType().m_49966_() : null;
    }

    @Nullable
    private IFluidHandler getFluidHandler(Level world, BlockPos blockPos, @Nullable Direction side) {
        return (IFluidHandler)FluidUtil.getFluidHandler((Level)world, (BlockPos)blockPos, (Direction)side).orElse(null);
    }

    private boolean tryInsertFluid(IFluidHandler destination, boolean doTransfer) {
        if (destination == null) {
            return false;
        }
        return destination.fill(this.fluidStack, doTransfer ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public boolean tryPlaceFluid(Player player, Level world, BlockPos blockPos, IModifiedSpellPart<SpellEffect> modificationData, boolean ignoreVaporize) {
        FluidStack resource = this.fluidStack;
        BlockState state = this.fluidStack.getFluid().getFluidType().getBlockForFluidState((BlockAndTintGetter)world, blockPos, this.fluidStack.getFluid().m_76145_());
        BlockWrapper wrapper = new BlockWrapper(state, world, blockPos);
        if (world.m_6042_().f_63857_() && resource.getFluid().getFluidType().isVaporizedOnPlacement(world, blockPos, resource) && (!ignoreVaporize || !((Boolean)CommonConfig.CAN_CONJURE_FLUID_IGNORE_VAPORIZE.get()).booleanValue())) {
            resource.getFluid().getFluidType().onVaporize(player, world, blockPos, resource);
            return true;
        }
        return wrapper.fill(this.fluidStack, IFluidHandler.FluidAction.EXECUTE) > 0;
    }
}

