/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.api.item;

import de.joh.dmnr.DragonMagicAndRelics;
import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.item.IDragonMagicContainerItem;
import de.joh.dmnr.common.util.Registries;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class UpgradeSealItem
extends Item {
    private final ResourceLocation armorUpgradeRL;

    public UpgradeSealItem(ResourceLocation armorUpgrade) {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
        this.armorUpgradeRL = armorUpgrade;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (Screen.m_96638_()) {
            ArmorUpgrade armorUpgrade = this.getArmorUpgrade();
            if (armorUpgrade != ArmorUpgrade.INSTANCE) {
                tooltip.add((Component)Component.m_237115_((String)(armorUpgrade.getRegistryName().toString() + ".description")));
                MutableComponent component0 = Component.m_237115_((String)"tooltip.dmnr.upgradeseal.max_level");
                tooltip.add((Component)Component.m_237113_((String)(component0.getString() + " " + armorUpgrade.maxUpgradeLevel)));
                MutableComponent component1 = Component.m_237115_((String)"tooltip.dmnr.upgradeseal");
                tooltip.add((Component)Component.m_237113_((String)(component1.getString() + " " + armorUpgrade.upgradeCost)));
                if (armorUpgrade.getStrongerAlternative() != null) {
                    tooltip.add((Component)Component.m_237113_((String)"  "));
                    MutableComponent component2 = Component.m_237115_((String)"tooltip.dmnr.upgradeseal.stronger_version");
                    MutableComponent component3 = Component.m_237115_((String)String.valueOf(armorUpgrade.getStrongerAlternative().getRegistryName()));
                    tooltip.add((Component)Component.m_237113_((String)(component2.getString() + " " + component3.getString())));
                }
                if (!armorUpgrade.supportsOnExtraLevel) {
                    tooltip.add((Component)Component.m_237113_((String)"  "));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.dmnr.upgradeseal.not_supports_extra_level"));
                }
            } else {
                tooltip.add((Component)Component.m_237113_((String)"ERROR"));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.dmnr.armor.tooltip"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@NotNull ItemStack itemstack) {
        return true;
    }

    @NotNull
    public ArmorUpgrade getArmorUpgrade() {
        ArmorUpgrade armorUpgrade = (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(this.armorUpgradeRL);
        if (armorUpgrade != null) {
            return armorUpgrade;
        }
        DragonMagicAndRelics.LOGGER.error("UpgradeSealItem: The following armor upgrade could not be found: " + this.armorUpgradeRL);
        return ArmorUpgrade.INSTANCE;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int m_8105_(@NotNull ItemStack itemstack) {
        return 40;
    }

    public void m_5929_(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int count) {
        if (count <= 1) {
            user.m_5810_();
            ItemStack dMContainerStack = user.m_21120_(InteractionHand.OFF_HAND);
            Item item = dMContainerStack.m_41720_();
            if (item instanceof IDragonMagicContainerItem) {
                IDragonMagicContainerItem dMContainer = (IDragonMagicContainerItem)item;
                int currentLevel = dMContainer.getUpgradeLevel(dMContainerStack, this.getArmorUpgrade());
                if (this.getArmorUpgrade().maxUpgradeLevel <= currentLevel) {
                    if (user instanceof Player) {
                        ((Player)user).m_5661_((Component)Component.m_237115_((String)"dmnr.ritual.output.upgrade.ritual.already_at_max.error"), true);
                    }
                    return;
                }
                if (!dMContainer.addDragonMagicToItem(dMContainerStack, this.getArmorUpgrade(), currentLevel + 1, false)) {
                    if (user instanceof Player) {
                        ((Player)user).m_5661_((Component)Component.m_237115_((String)"dmnr.ritual.output.upgrade.ritual.unexpected.error"), true);
                    }
                    return;
                }
                user.m_9236_().m_214150_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 0.9f + (float)Math.random() * 0.2f, 0L);
                if (!(user instanceof Player) || !((Player)user).m_7500_()) {
                    user.m_21008_(user.m_7655_(), ItemStack.f_41583_);
                }
            } else if (user instanceof Player) {
                ((Player)user).m_5661_((Component)Component.m_237115_((String)"dmnr.ritual.output.upgrade.ritual.no_dm_container.error"), true);
            }
            if (user instanceof Player) {
                ((Player)user).m_36335_().m_41524_((Item)this, 20);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }
}

