/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.api.item;

import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.item.DragonMageArmorItem;
import de.joh.dmnr.capabilities.dragonmagic.ArmorUpgradeHelper;
import de.joh.dmnr.capabilities.dragonmagic.PlayerDragonMagicProvider;
import de.joh.dmnr.common.util.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IDragonMagicContainerItem {
    public int getMaxDragonMagic(ItemStack var1);

    default public int getUpgradeLevel(ItemStack itemStack, ArmorUpgrade armorUpgrade) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("dmnrarmor_upgrade")) {
            CompoundTag nbt = itemStack.m_41783_().m_128469_("dmnrarmor_upgrade");
            for (String upgradeKey : nbt.m_128431_()) {
                int level = nbt.m_128451_(upgradeKey);
                ArmorUpgrade installedArmorUpgrade = (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(new ResourceLocation(upgradeKey));
                if (!armorUpgrade.equals(installedArmorUpgrade)) continue;
                return level;
            }
        }
        return 0;
    }

    default public boolean addDragonMagicToItem(ItemStack itemStack, ArmorUpgrade armorUpgrade, int level, boolean force) {
        ArmorUpgrade savedUpgrade;
        int spentPoints;
        CompoundTag nbt;
        if (!itemStack.m_41782_()) {
            if (!force) {
                level = Math.min(level, armorUpgrade.maxUpgradeLevel);
            } else if (!armorUpgrade.isInfStackable) {
                level = Math.min(level, armorUpgrade.supportsOnExtraLevel ? armorUpgrade.maxUpgradeLevel + 1 : armorUpgrade.maxUpgradeLevel);
            }
            nbt = new CompoundTag();
            spentPoints = 0;
            for (String key : nbt.m_128431_()) {
                savedUpgrade = (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(new ResourceLocation(key));
                if (savedUpgrade == armorUpgrade || savedUpgrade == null) continue;
                spentPoints += savedUpgrade.upgradeCost * nbt.m_128451_(key);
            }
            if ((spentPoints += armorUpgrade.upgradeCost * level) <= this.getMaxDragonMagic(itemStack) || force) {
                CompoundTag mainNBT = new CompoundTag();
                nbt.m_128405_(armorUpgrade.getRegistryName().toString(), level);
                mainNBT.m_128405_("dmnrspent_dp", spentPoints);
                mainNBT.m_128365_("dmnrarmor_upgrade", (Tag)nbt);
                itemStack.m_41751_(mainNBT);
                return true;
            }
        }
        if (itemStack.m_41782_()) {
            if (!force) {
                level = Math.min(level, armorUpgrade.maxUpgradeLevel);
            } else if (!armorUpgrade.isInfStackable) {
                level = Math.min(level, armorUpgrade.supportsOnExtraLevel ? armorUpgrade.maxUpgradeLevel + 1 : armorUpgrade.maxUpgradeLevel);
            }
            nbt = new CompoundTag();
            if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("dmnrarmor_upgrade")) {
                nbt = itemStack.m_41783_().m_128469_("dmnrarmor_upgrade");
            }
            spentPoints = 0;
            for (String key : nbt.m_128431_()) {
                savedUpgrade = (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(new ResourceLocation(key));
                if (savedUpgrade == armorUpgrade || savedUpgrade == null) continue;
                spentPoints += savedUpgrade.upgradeCost * nbt.m_128451_(key);
            }
            if ((spentPoints += armorUpgrade.upgradeCost * level) <= this.getMaxDragonMagic(itemStack) || force) {
                itemStack.m_41783_().m_128473_("dmnrarmor_upgrade");
                nbt.m_128405_(armorUpgrade.getRegistryName().toString(), level);
                itemStack.m_41783_().m_128405_("dmnrspent_dp", spentPoints);
                itemStack.m_41783_().m_128365_("dmnrarmor_upgrade", (Tag)nbt);
                return true;
            }
        }
        return false;
    }

    default public int getSpentDragonPoints(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_("dmnrspent_dp");
        }
        return 0;
    }

    default public void addDragonMagic(ItemStack itemStack, Player player, String sourceExtension) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("dmnrarmor_upgrade")) {
            DragonMageArmorItem dragonMageArmor;
            Item item;
            CompoundTag nbt = itemStack.m_41783_().m_128469_("dmnrarmor_upgrade");
            player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
                for (String upgradeKey : nbt.m_128431_()) {
                    int level = nbt.m_128451_(upgradeKey);
                    ArmorUpgrade armorUpgrade = (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(new ResourceLocation(upgradeKey));
                    if (armorUpgrade == null) continue;
                    playerCapability.addUpgrade(sourceExtension + armorUpgrade.getSourceID(level), armorUpgrade, level, player);
                }
            });
            ArmorUpgradeHelper.deactivateAllPerma(player, false);
            ArmorUpgradeHelper.activateOnEquipPerma(player);
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (!chest.m_41619_() && (item = chest.m_41720_()) instanceof DragonMageArmorItem && (dragonMageArmor = (DragonMageArmorItem)item).isSetEquipped((LivingEntity)player)) {
                ArmorUpgradeHelper.deactivateAll(player, false);
                ArmorUpgradeHelper.activateOnEquip(player);
            }
        }
    }

    default public void removeDragonMagic(ItemStack itemStack, Player player, String sourceExtension) {
        DragonMageArmorItem dragonMageArmor;
        Item item;
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("dmnrarmor_upgrade")) {
            CompoundTag nbt = itemStack.m_41783_().m_128469_("dmnrarmor_upgrade");
            player.getCapability(PlayerDragonMagicProvider.PLAYER_DRAGON_MAGIC).ifPresent(playerCapability -> {
                for (String upgradeKey : nbt.m_128431_()) {
                    ArmorUpgrade armorUpgrade = (ArmorUpgrade)Registries.ARMOR_UPGRADE.get().getValue(new ResourceLocation(upgradeKey));
                    if (armorUpgrade == null) continue;
                    playerCapability.removeUpgrade(sourceExtension + armorUpgrade.getSourceID(nbt.m_128451_(upgradeKey)), player);
                }
            });
        }
        ArmorUpgradeHelper.deactivateAllPerma(player, false);
        ArmorUpgradeHelper.activateOnEquipPerma(player);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (!chest.m_41619_() && (item = chest.m_41720_()) instanceof DragonMageArmorItem && (dragonMageArmor = (DragonMageArmorItem)item).isSetEquipped((LivingEntity)player)) {
            ArmorUpgradeHelper.deactivateAll(player, false);
            ArmorUpgradeHelper.activateOnEquip(player);
        }
    }
}

