/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.api.item;

import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.IDelayedEvent;
import com.mna.api.timing.TimedDelayedSpellEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.ItemInit;
import com.mna.items.armor.ISetItem;
import com.mna.items.base.IItemWithGui;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import de.joh.dmnr.api.item.IDragonMagicContainerItem;
import de.joh.dmnr.capabilities.dragonmagic.ArmorUpgradeHelper;
import de.joh.dmnr.client.item.armor.DragonMageArmorRenderer;
import de.joh.dmnr.common.init.EffectInit;
import de.joh.dmnr.common.item.material.ArmorMaterials;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.extensions.IForgeItem;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public abstract class DragonMageArmorItem
extends ArmorItem
implements IItemWithGui<DragonMageArmorItem>,
IForgeItem,
ISetItem,
IDragonMagicContainerItem,
GeoItem {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final ResourceLocation dragonMageArmorSetBonus;

    public DragonMageArmorItem(ArmorItem.Type type, ResourceLocation dragonMageArmorSetBonus) {
        super((ArmorMaterial)ArmorMaterials.DRAGON_MAGE_ARMOR_MATERIAL, type, new Item.Properties().m_41497_(Rarity.EPIC).m_41486_());
        this.dragonMageArmorSetBonus = dragonMageArmorSetBonus;
    }

    public abstract ResourceLocation getWingTextureLocation();

    public static void applySpell(ItemStack stack, boolean isOther, Player self, @Nullable Entity other) {
        SpellRecipe recipe;
        ItemInventoryBase inv;
        ItemStack slot;
        if (stack.m_41720_() instanceof DragonMageArmorItem && ((DragonMageArmorItem)stack.m_41720_()).f_265916_ == ArmorItem.Type.CHESTPLATE && (slot = (inv = new ItemInventoryBase(stack)).getStackInSlot(isOther ? 1 : 0)).m_41720_() != ItemInit.ENCHANTED_VELLUM.get() && (!isOther || other != null) && !slot.m_41619_() && SpellRecipe.stackContainsSpell((ItemStack)slot) && !self.m_9236_().f_46443_ && (recipe = SpellRecipe.fromNBT((CompoundTag)slot.m_41783_())).isValid()) {
            MutableBoolean consumed = new MutableBoolean(false);
            self.getCapability(PlayerMagicProvider.MAGIC).ifPresent(c -> {
                if (c.getCastingResource().hasEnoughAbsolute((LivingEntity)self, recipe.getManaCost())) {
                    c.getCastingResource().consume((LivingEntity)self, recipe.getManaCost());
                    consumed.setTrue();
                }
            });
            if (consumed.getValue().booleanValue()) {
                SpellSource source = new SpellSource((LivingEntity)self, InteractionHand.MAIN_HAND);
                SpellContext context = new SpellContext(self.m_9236_(), (ISpellDefinition)recipe);
                recipe.iterateComponents(c -> {
                    int delay = (int)(c.getValue(Attribute.DELAY) * 20.0f);
                    boolean appliedComponent = false;
                    if (delay > 0) {
                        DelayedEventQueue.pushEvent((Level)self.m_9236_(), (IDelayedEvent)new TimedDelayedSpellEffect(((SpellEffect)c.getPart()).getRegistryName().toString(), delay, source, new SpellTarget((Entity)(isOther ? other : self)), c, context));
                        appliedComponent = true;
                    } else if (((SpellEffect)c.getPart()).ApplyEffect(source, new SpellTarget((Entity)(isOther ? other : self)), c, context) == ComponentApplicationResult.SUCCESS) {
                        appliedComponent = true;
                    }
                    if (appliedComponent) {
                        SpellCaster.addComponentRoteProgress((Player)self, (SpellEffect)((SpellEffect)c.getPart()));
                    }
                });
            }
        }
    }

    public abstract ResourceLocation getTextureLocation();

    @Override
    public int getMaxDragonMagic(ItemStack itemStack) {
        return this.f_265916_ == ArmorItem.Type.CHESTPLATE ? 64 : 0;
    }

    public void applyDragonMagicSetBonus(LivingEntity living) {
        if (living instanceof Player) {
            if (living.m_21023_((MobEffect)EffectInit.ULTIMATE_ARMOR.get())) {
                ArmorUpgradeHelper.ultimateArmorStart((Player)living);
            } else {
                ArmorUpgradeHelper.activateOnEquip((Player)living);
            }
        }
    }

    public void removeDragonMagicSetBonus(LivingEntity living) {
        if (living instanceof Player) {
            if (living.m_21023_((MobEffect)EffectInit.ULTIMATE_ARMOR.get())) {
                ArmorUpgradeHelper.ultimateArmorFin((Player)living);
            } else {
                ArmorUpgradeHelper.deactivateAll((Player)living);
            }
        }
    }

    public void onEquip(ItemStack itemStack, LivingEntity entity) {
        if (entity instanceof Player) {
            this.addDragonMagic(itemStack, (Player)entity, "dm_armor");
        }
    }

    public void onDiscard(ItemStack itemStack, LivingEntity entity) {
        if (entity instanceof Player) {
            this.removeDragonMagic(itemStack, (Player)entity, "dm_armor");
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack held;
        if (!world.f_46443_ && this.f_265916_ == ArmorItem.Type.CHESTPLATE && this.openGuiIfModifierPressed(held = player.m_21120_(hand), player, world)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)held);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (this.f_265916_ != ArmorItem.Type.CHESTPLATE) {
            return;
        }
        if (Screen.m_96638_()) {
            CompoundTag nbt;
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("dmnrarmor_upgrade") && !(nbt = stack.m_41783_().m_128469_("dmnrarmor_upgrade")).m_128431_().isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.dmnr.armor.tooltip.upgrade.base"));
                for (String key : nbt.m_128431_()) {
                    if (nbt.m_128451_(key) <= 0) continue;
                    MutableComponent component = Component.m_237115_((String)key);
                    tooltip.add((Component)Component.m_237113_((String)(component.getString() + ": " + nbt.m_128451_(key))));
                }
                tooltip.add((Component)Component.m_237113_((String)"  "));
            }
            MutableComponent component = Component.m_237115_((String)"tooltip.dmnr.dm_container.tooltip.remaining.dmpoints");
            tooltip.add((Component)Component.m_237113_((String)(component.getString() + (this.getMaxDragonMagic(stack) - this.getSpentDragonPoints(stack)))));
            tooltip.add((Component)Component.m_237113_((String)"  "));
            super.m_7373_(stack, world, tooltip, flag);
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.dmnr.armor.tooltip"));
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return super.damageItem(stack, 0, entity, onBroken);
    }

    public ResourceLocation getSetIdentifier() {
        return this.dragonMageArmorSetBonus;
    }

    public int itemsForSetBonus() {
        return 4;
    }

    public boolean wouldSetBeEquipped(LivingEntity living, Item item) {
        ItemStack stack;
        EquipmentSlot slot;
        if (living == null) {
            return false;
        }
        int count = 0;
        this.getValidSetSlots();
        for (int i = 0; i < this.getValidSetSlots().length; ++i) {
            slot = this.getValidSetSlots()[i];
            if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND || !((stack = living.m_6844_(slot)).m_41720_() instanceof DragonMageArmorItem) || !((DragonMageArmorItem)stack.m_41720_()).getSetIdentifier().equals((Object)this.getSetIdentifier())) continue;
            ++count;
        }
        if (item instanceof DragonMageArmorItem) {
            boolean isValidSlot = false;
            slot = ((ArmorItem)item).m_266204_().m_266308_();
            stack = this.getValidSetSlots();
            int n = ((ItemStack)stack).length;
            for (int i = 0; i < n; ++i) {
                ItemStack es = stack[i];
                isValidSlot = isValidSlot || slot == es;
            }
            if (!(!isValidSlot || (stack = living.m_6844_(slot)).m_41720_() instanceof DragonMageArmorItem && ((DragonMageArmorItem)stack.m_41720_()).getSetIdentifier().equals((Object)this.getSetIdentifier()))) {
                ++count;
            }
        }
        return count >= this.itemsForSetBonus();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private DragonMageArmorRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new DragonMageArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@NotNull ItemStack itemStack) {
        return false;
    }
}

