/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.api.event;

import com.mna.api.faction.IFaction;
import com.mna.factions.Factions;
import com.mna.items.armor.BoneArmorItem;
import com.mna.items.armor.CouncilArmorItem;
import com.mna.items.armor.DemonArmorItem;
import com.mna.items.armor.FeyArmorItem;
import com.mna.items.armor.ISetItem;
import de.joh.dmnr.api.armorupgrade.ArmorUpgrade;
import de.joh.dmnr.api.item.DragonMageArmorItem;
import de.joh.dmnr.common.init.ArmorUpgradeInit;
import de.joh.dmnr.common.init.ItemInit;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class DragonUpgradeEvent
extends PlayerEvent {
    private boolean canBeUpgraded;
    private final IFaction targetFaction;
    private HashMap<ArmorUpgrade, Integer> initialUpgrades;
    private final ItemStack headOld;
    private final ItemStack chestOld;
    private final ItemStack legsOld;
    private final ItemStack feetOld;
    private ItemStack headNew = null;
    private ItemStack chestNew = null;
    private ItemStack legsNew = null;
    private ItemStack feetNew = null;

    public DragonUpgradeEvent(Player player, IFaction targetFaction) {
        super(player);
        this.targetFaction = targetFaction;
        this.initialUpgrades = DragonUpgradeEvent.getBaseInitialUpgrades(targetFaction);
        this.headOld = player.m_6844_(EquipmentSlot.HEAD);
        this.chestOld = player.m_6844_(EquipmentSlot.CHEST);
        this.legsOld = player.m_6844_(EquipmentSlot.LEGS);
        this.feetOld = player.m_6844_(EquipmentSlot.FEET);
        if (!((this.chestOld.m_41720_() instanceof BoneArmorItem || this.chestOld.m_41720_() instanceof CouncilArmorItem || this.chestOld.m_41720_() instanceof DemonArmorItem || this.chestOld.m_41720_() instanceof FeyArmorItem || this.chestOld.m_41720_() instanceof DragonMageArmorItem) && ((ISetItem)this.chestOld.m_41720_()).isSetEquipped((LivingEntity)player))) {
            this.canBeUpgraded = false;
            return;
        }
        ((ISetItem)player.m_6844_(EquipmentSlot.CHEST).m_41720_()).removeSetBonus((LivingEntity)player, new EquipmentSlot[]{EquipmentSlot.CHEST});
        if (targetFaction == Factions.UNDEAD) {
            this.headNew = new ItemStack((ItemLike)ItemInit.ABYSSAL_DRAGON_MAGE_HELMET.get());
            this.chestNew = new ItemStack((ItemLike)ItemInit.ABYSSAL_DRAGON_MAGE_CHESTPLATE.get());
            this.legsNew = new ItemStack((ItemLike)ItemInit.ABYSSAL_DRAGON_MAGE_LEGGING.get());
            this.feetNew = new ItemStack((ItemLike)ItemInit.ABYSSAL_DRAGON_MAGE_BOOTS.get());
        } else if (targetFaction == Factions.COUNCIL) {
            this.headNew = new ItemStack((ItemLike)ItemInit.ARCH_DRAGON_MAGE_HELMET.get());
            this.chestNew = new ItemStack((ItemLike)ItemInit.ARCH_DRAGON_MAGE_CHESTPLATE.get());
            this.legsNew = new ItemStack((ItemLike)ItemInit.ARCH_DRAGON_MAGE_LEGGING.get());
            this.feetNew = new ItemStack((ItemLike)ItemInit.ARCH_DRAGON_MAGE_BOOTS.get());
        } else if (targetFaction == Factions.FEY) {
            this.headNew = new ItemStack((ItemLike)ItemInit.WILD_DRAGON_MAGE_HELMET.get());
            this.chestNew = new ItemStack((ItemLike)ItemInit.WILD_DRAGON_MAGE_CHESTPLATE.get());
            this.legsNew = new ItemStack((ItemLike)ItemInit.WILD_DRAGON_MAGE_LEGGING.get());
            this.feetNew = new ItemStack((ItemLike)ItemInit.WILD_DRAGON_MAGE_BOOTS.get());
        } else if (targetFaction == Factions.DEMONS) {
            this.headNew = new ItemStack((ItemLike)ItemInit.INFERNAL_DRAGON_MAGE_HELMET.get());
            this.chestNew = new ItemStack((ItemLike)ItemInit.INFERNAL_DRAGON_MAGE_CHESTPLATE.get());
            this.legsNew = new ItemStack((ItemLike)ItemInit.INFERNAL_DRAGON_MAGE_LEGGING.get());
            this.feetNew = new ItemStack((ItemLike)ItemInit.INFERNAL_DRAGON_MAGE_BOOTS.get());
        }
        this.canBeUpgraded = true;
    }

    public void performUpgrade(boolean addBaseUpgrades) {
        CompoundTag nbtData;
        if (!this.canBeUpgraded) {
            return;
        }
        if (this.headOld.m_41782_() && this.headNew.m_41783_() != null) {
            nbtData = new CompoundTag();
            nbtData.m_128365_("Enchantments", (Tag)this.headOld.m_41785_());
            this.headNew.m_41783_().m_128391_(nbtData);
        }
        if (this.chestOld.m_41782_() && this.chestNew.m_41783_() != null) {
            nbtData = new CompoundTag();
            nbtData.m_128365_("Enchantments", (Tag)this.chestOld.m_41785_());
            this.chestNew.m_41783_().m_128391_(nbtData);
        }
        if (this.legsOld.m_41782_() && this.legsNew.m_41783_() != null) {
            nbtData = new CompoundTag();
            nbtData.m_128365_("Enchantments", (Tag)this.legsOld.m_41785_());
            this.legsNew.m_41783_().m_128391_(nbtData);
        }
        if (this.feetOld.m_41782_() && this.feetNew.m_41783_() != null) {
            nbtData = new CompoundTag();
            nbtData.m_128365_("Enchantments", (Tag)this.feetOld.m_41785_());
            this.feetNew.m_41783_().m_128391_(nbtData);
        }
        this.getEntity().m_8061_(EquipmentSlot.HEAD, this.headNew);
        this.getEntity().m_8061_(EquipmentSlot.CHEST, this.chestNew);
        this.getEntity().m_8061_(EquipmentSlot.LEGS, this.legsNew);
        this.getEntity().m_8061_(EquipmentSlot.FEET, this.feetNew);
        if (addBaseUpgrades) {
            this.initialUpgrades.forEach(this::addUpgrade);
        }
    }

    public void performUpgradeFromDMArmor() {
        this.performUpgrade(false);
        if (this.chestOld.m_41720_() instanceof DragonMageArmorItem && this.chestOld.m_41782_()) {
            this.chestNew.m_41751_(this.chestOld.m_41783_());
        }
    }

    private void addUpgrade(ArmorUpgrade upgrade, int level) {
        ItemStack itemStack = this.getEntity().m_6844_(EquipmentSlot.CHEST);
        ((DragonMageArmorItem)itemStack.m_41720_()).addDragonMagicToItem(itemStack, upgrade, level, true);
    }

    public boolean canBeUpgraded() {
        return this.canBeUpgraded;
    }

    public IFaction getTargetFaction() {
        return this.targetFaction;
    }

    public void setAlternativeArmorValues(ItemStack headNew, ItemStack chestNew, ItemStack legsNew, ItemStack feetNew, HashMap<ArmorUpgrade, Integer> initialUpgrades) {
        this.headNew = headNew;
        this.chestNew = chestNew;
        this.legsNew = legsNew;
        this.feetNew = feetNew;
        this.initialUpgrades = initialUpgrades;
        this.canBeUpgraded = true;
    }

    private static HashMap<ArmorUpgrade, Integer> getBaseInitialUpgrades(IFaction targetFaction) {
        HashMap<ArmorUpgrade, Integer> ret = new HashMap<ArmorUpgrade, Integer>();
        if (targetFaction == Factions.UNDEAD) {
            ret.put(ArmorUpgradeInit.MIST_FORM, 1);
            ret.put(ArmorUpgradeInit.MANA_REGEN, 2);
            ret.put(ArmorUpgradeInit.DAMAGE_RESISTANCE, 1);
        } else if (targetFaction == Factions.COUNCIL) {
            ret.put(ArmorUpgradeInit.FLY, 1);
            ret.put(ArmorUpgradeInit.PROJECTILE_REFLECTION, 3);
            ret.put(ArmorUpgradeInit.MAJOR_MANA_BOOST, 4);
            ret.put(ArmorUpgradeInit.MANA_REGEN, 3);
        } else if (targetFaction == Factions.FEY) {
            ret.put(ArmorUpgradeInit.ANGEL_FLIGHT, 2);
            ret.put(ArmorUpgradeInit.SATURATION, 1);
            ret.put(ArmorUpgradeInit.REACH_DISTANCE, 1);
        } else if (targetFaction == Factions.DEMONS) {
            ret.put(ArmorUpgradeInit.BURNING_FRENZY, 1);
            ret.put(ArmorUpgradeInit.METEOR_JUMP, 1);
            ret.put(ArmorUpgradeInit.DAMAGE_BOOST, 2);
            ret.put(ArmorUpgradeInit.JUMP, 2);
            ret.put(ArmorUpgradeInit.MAJOR_FIRE_RESISTANCE, 1);
        }
        return ret;
    }
}

