/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.api.armorupgrade;

import de.joh.dmnr.api.armorupgrade.OnEquippedArmorUpgrade;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public abstract class PotionEffectArmorUpgrade
extends OnEquippedArmorUpgrade {
    public static final int EFFECT_DURATION = -1;
    private final int factor;

    public PotionEffectArmorUpgrade(@NotNull ResourceLocation registryName, int maxUpgradeLevel, RegistryObject<Item> upgradeSealItem, int factor, boolean isInfStackable, boolean supportsOnExtraLevel, int upgradeCost) {
        super(registryName, maxUpgradeLevel, upgradeSealItem, isInfStackable, supportsOnExtraLevel, upgradeCost);
        this.factor = factor;
    }

    public PotionEffectArmorUpgrade(@NotNull ResourceLocation registryName, int maxUpgradeLevel, RegistryObject<Item> upgradeSealItem, boolean isInfStackable, int upgradeCost) {
        this(registryName, maxUpgradeLevel, upgradeSealItem, 1, isInfStackable, true, upgradeCost);
    }

    @NotNull
    public abstract MobEffect getMobEffect();

    public void applyPotionAffect(Player player, int level) {
        MobEffectInstance instance = player.m_21124_(this.getMobEffect());
        if (instance == null || instance.m_19564_() < level * this.factor - 1) {
            player.m_7292_(new MobEffectInstance(this.getMobEffect(), -1, level * this.factor - 1, false, false, false));
        } else {
            instance.m_19558_(new MobEffectInstance(this.getMobEffect(), -1, level * this.factor - 1, false, false, false));
        }
    }

    @Override
    public void onRemove(Player player) {
        player.m_21195_(this.getMobEffect());
    }

    @Override
    public void onEquip(Player player, int level) {
        this.applyPotionAffect(player, level);
    }
}

