/*
 * Decompiled with CFR 0.152.
 */
package de.joh.dmnr.api.armorupgrade;

import de.joh.dmnr.common.init.ItemInit;
import de.joh.dmnr.common.util.RLoc;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorUpgrade {
    public static ArmorUpgrade INSTANCE = new ArmorUpgrade(RLoc.create("armorupgrade/none"), 0, ItemInit.BLANK_UPGRADE_SEAL, false, false, 0);
    public final int upgradeCost;
    public final int maxUpgradeLevel;
    private final RegistryObject<Item> upgradeSealItem;
    public final boolean supportsOnExtraLevel;
    public final boolean isInfStackable;
    private final ResourceLocation registryName;

    public ArmorUpgrade(ResourceLocation registryName, int maxUpgradeLevel, RegistryObject<Item> upgradeSealItem, boolean isInfStackable, boolean supportsOnExtraLevel, int upgradeCost) {
        this.registryName = registryName;
        this.maxUpgradeLevel = maxUpgradeLevel;
        this.isInfStackable = isInfStackable;
        this.upgradeCost = upgradeCost;
        this.supportsOnExtraLevel = supportsOnExtraLevel;
        this.upgradeSealItem = upgradeSealItem;
    }

    public ArmorUpgrade(ResourceLocation registryName, int maxUpgradeLevel, RegistryObject<Item> upgradeSealItem, boolean isInfStackable, int upgradeCost) {
        this.registryName = registryName;
        this.maxUpgradeLevel = maxUpgradeLevel;
        this.isInfStackable = isInfStackable;
        this.upgradeCost = upgradeCost;
        this.supportsOnExtraLevel = isInfStackable;
        this.upgradeSealItem = upgradeSealItem;
    }

    @NotNull
    public Item getSeal() {
        return (Item)this.upgradeSealItem.get();
    }

    public void onRemove(Player player) {
    }

    public final boolean hasStrongerAlternative() {
        return this.getStrongerAlternative() != null;
    }

    @Nullable
    public ArmorUpgrade getStrongerAlternative() {
        return null;
    }

    public String getSourceID(int level) {
        return this.registryName.toString() + "_" + level;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

