/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.bakery.core.block.entity.CabinetBlockEntity;
import net.satisfy.bakery.core.block.entity.CompletionistBannerEntity;
import net.satisfy.bakery.core.block.entity.SmallCookingPotBlockEntity;
import net.satisfy.bakery.core.block.entity.StorageBlockEntity;
import net.satisfy.bakery.core.block.entity.StreetSignBlockEntity;
import net.satisfy.bakery.core.registry.ObjectRegistry;
import net.satisfy.bakery.core.registry.StorageTypeRegistry;
import net.satisfy.bakery.core.util.BakeryIdentifier;

public class EntityTypeRegistry {
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.f_256922_).getRegistrar();
    public static final RegistrySupplier<BlockEntityType<SmallCookingPotBlockEntity>> SMALL_COOKING_POT_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("small_cooking_pot", () -> BlockEntityType.Builder.m_155273_(SmallCookingPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SMALL_COOKING_POT.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> BAKERY_BANNER = EntityTypeRegistry.registerBlockEntity("bakery_banner", () -> BlockEntityType.Builder.m_155273_(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BAKERY_BANNER.get(), (Block)ObjectRegistry.BAKERY_WALL_BANNER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.m_155273_(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.m_155273_(CabinetBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StreetSignBlockEntity>> STREET_SIGN_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("street_sign", () -> BlockEntityType.Builder.m_155273_(StreetSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.STREET_SIGN.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String name, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new BakeryIdentifier(name), type);
    }

    public static void init() {
    }
}

