/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.block.cake;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.bakery.core.registry.SoundEventRegistry;
import net.satisfy.bakery.core.registry.TagsRegistry;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class PieBlock
extends FacingBlock {
    public static final IntegerProperty CUTS = IntegerProperty.m_61631_((String)"cuts", (int)0, (int)3);
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });
    public final Supplier<Item> Slice;

    public PieBlock(BlockBehaviour.Properties settings, Supplier<Item> slice) {
        super(settings);
        this.Slice = slice != null ? slice : () -> Items.f_41852_;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CUTS, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CUTS});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxCuts() - (Integer)blockState.m_61143_((Property)CUTS);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public ItemStack getPieSliceItem() {
        return new ItemStack((ItemLike)(this.Slice != null ? (ItemLike)this.Slice.get() : Items.f_41852_));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!level.f_46443_ && !player.m_6144_() && (Integer)state.m_61143_((Property)CUTS) == 0 && heldStack.m_41619_()) {
            Direction direction = player.m_6350_().m_122424_();
            double xMotion = (double)direction.m_122429_() * 0.13;
            double yMotion = 0.35;
            double zMotion = (double)direction.m_122431_() * 0.13;
            GeneralUtil.spawnSlice((Level)level, (ItemStack)new ItemStack((ItemLike)this), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (double)xMotion, (double)yMotion, (double)zMotion);
            level.m_7471_(pos, false);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && (heldStack.m_41619_() || heldStack.m_204117_(TagsRegistry.KNIVES))) {
            return this.consumeBite(level, pos, state, player);
        }
        if (!player.m_6144_() && heldStack.m_204117_(TagsRegistry.KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int cuts;
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPieSliceItem();
        FoodProperties sliceFood = sliceStack.m_41720_().m_41473_();
        playerIn.m_36324_().m_38712_(sliceStack.m_41720_(), sliceStack);
        if (this.getPieSliceItem().m_41720_().m_41472_() && sliceFood != null) {
            for (Pair pair : sliceFood.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                playerIn.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if ((cuts = ((Integer)state.m_61143_((Property)CUTS)).intValue()) < this.getMaxCuts() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CUTS, (Comparable)Integer.valueOf(cuts + 1)), 3);
        } else {
            level.m_46961_(pos, false);
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int cuts = (Integer)state.m_61143_((Property)CUTS);
        if (cuts < this.getMaxCuts() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CUTS, (Comparable)Integer.valueOf(cuts + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        Direction direction = player.m_6350_().m_122424_();
        double xMotion = (double)direction.m_122429_() * 0.13;
        double yMotion = 0.35;
        double zMotion = (double)direction.m_122431_() * 0.13;
        GeneralUtil.spawnSlice((Level)level, (ItemStack)this.getPieSliceItem(), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)xMotion, (double)yMotion, (double)zMotion);
        level.m_5594_(null, pos, (SoundEvent)SoundEventRegistry.CAKE_CUT.get(), SoundSource.PLAYERS, 0.75f, 0.75f);
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return GeneralUtil.isFullAndSolid((LevelReader)levelReader, (BlockPos)blockPos);
    }

    public int getMaxCuts() {
        return 4;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bakery.canbeplaced").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bakery.cake_1").m_130940_(ChatFormatting.WHITE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bakery.cake_2").m_130940_(ChatFormatting.WHITE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bakery.cake_3").m_130940_(ChatFormatting.WHITE));
    }
}

