/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.bakery.core.block.StorageBlock;
import net.satisfy.bakery.core.registry.StorageTypeRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CakeDisplayBlock
extends StorageBlock {
    public static final DirectionProperty FACING;
    public static final EnumProperty<GeneralUtil.LineConnectingType> TYPE;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    public static final Map<Direction, VoxelShape> SHAPE;

    public CakeDisplayBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)GeneralUtil.LineConnectingType.NONE));
    }

    @Override
    public int size() {
        return 6;
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.CAKE_DISPLAY;
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        return !(stack.m_41720_() instanceof BlockItem);
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN, Direction.UP};
    }

    @Override
    public int getSection(Float x, Float y) {
        int i = y.floatValue() >= 0.5f ? 0 : 1;
        int j = CakeDisplayBlock.getXSection(x.floatValue());
        return j + i * 3;
    }

    private static int getXSection(float f) {
        if (f < 0.375f) {
            return 2;
        }
        return f < 0.6875f ? 1 : 0;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        Level world = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        return switch (facing) {
            case Direction.EAST -> (BlockState)blockState.m_61124_(TYPE, (Comparable)this.getType(blockState, world.m_8055_(clickedPos.m_122019_()), world.m_8055_(clickedPos.m_122012_())));
            case Direction.SOUTH -> (BlockState)blockState.m_61124_(TYPE, (Comparable)this.getType(blockState, world.m_8055_(clickedPos.m_122024_()), world.m_8055_(clickedPos.m_122029_())));
            case Direction.WEST -> (BlockState)blockState.m_61124_(TYPE, (Comparable)this.getType(blockState, world.m_8055_(clickedPos.m_122012_()), world.m_8055_(clickedPos.m_122019_())));
            default -> (BlockState)blockState.m_61124_(TYPE, (Comparable)this.getType(blockState, world.m_8055_(clickedPos.m_122029_()), world.m_8055_(clickedPos.m_122024_())));
        };
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        GeneralUtil.LineConnectingType type = switch (facing) {
            case Direction.EAST -> this.getType(state, world.m_8055_(pos.m_122019_()), world.m_8055_(pos.m_122012_()));
            case Direction.SOUTH -> this.getType(state, world.m_8055_(pos.m_122024_()), world.m_8055_(pos.m_122029_()));
            case Direction.WEST -> this.getType(state, world.m_8055_(pos.m_122012_()), world.m_8055_(pos.m_122019_()));
            default -> this.getType(state, world.m_8055_(pos.m_122029_()), world.m_8055_(pos.m_122024_()));
        };
        if (state.m_61143_(TYPE) != type) {
            state = (BlockState)state.m_61124_(TYPE, (Comparable)type);
        }
        world.m_7731_(pos, state, 3);
    }

    public GeneralUtil.LineConnectingType getType(BlockState state, BlockState left, BlockState right) {
        boolean shape_right_same;
        boolean shape_left_same = left.m_60734_() == state.m_60734_() && left.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        boolean bl = shape_right_same = right.m_60734_() == state.m_60734_() && right.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        if (shape_left_same && shape_right_same) {
            return GeneralUtil.LineConnectingType.MIDDLE;
        }
        if (shape_left_same) {
            return GeneralUtil.LineConnectingType.LEFT;
        }
        if (shape_right_same) {
            return GeneralUtil.LineConnectingType.RIGHT;
        }
        return GeneralUtil.LineConnectingType.NONE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bakery.canbeplaced").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.1875, (double)1.0, (double)0.0625, (double)0.9375));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0625, (double)0.375, (double)1.0, (double)0.875, (double)0.9375));
            return shape;
        };
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
            }
        });
        FACING = BlockStateProperties.f_61374_;
        TYPE = GeneralUtil.LINE_CONNECTING_TYPE;
    }
}

