/*
 * Decompiled with CFR 0.152.
 */
package mc.duzo.animation.util;

import mc.duzo.animation.api.AnimationEvents;
import mc.duzo.animation.generic.AnimationHolder;
import mc.duzo.animation.generic.AnimationInfo;
import mc.duzo.animation.generic.AnimationTracker;
import mc.duzo.animation.registry.client.TrackerRegistry;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.LivingEntity;

public class AnimationUtil {
    public static AnimationInfo getInfo(AbstractClientPlayer player) {
        for (AnimationTracker tracker : TrackerRegistry.REGISTRY) {
            Object holder = tracker.get((LivingEntity)player);
            if (holder == null) continue;
            return ((AnimationHolder)holder).getInfo();
        }
        AnimationEvents.Result<AnimationInfo> result = ((AnimationEvents.FindAnimationInfo)AnimationEvents.FIND_ANIMATION_INFO.invoker()).getAnimationInfo(player);
        if (result.result().isEmpty()) {
            return null;
        }
        return result.result().get();
    }

    public static boolean isRunningAnimations(AbstractClientPlayer player) {
        AnimationInfo info = AnimationUtil.getInfo(player);
        return info != null && info.transform() != null;
    }
}

