/*
 * Decompiled with CFR 0.152.
 */
package mc.duzo.animation.player;

import java.util.Optional;
import mc.duzo.animation.player.PlayerAnimationTracker;
import mc.duzo.animation.player.PlayerModelHook;
import mc.duzo.animation.player.holder.PlayerAnimationHolder;
import mc.duzo.animation.registry.AnimationRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class PlayerAnimationHelper {
    public static final AnimationChannel.Interpolation STEP = (dest, delta, keyframes, start, end, scale) -> {
        Vector3f vector3f = keyframes[start].f_232284_();
        Vector3f vector3f2 = keyframes[end].f_232284_();
        return vector3f.lerp((Vector3fc)vector3f2, 0.0f, dest).mul(scale);
    };

    public static void animate(PlayerModel<?> model, AnimationDefinition animation, long runningTime, float scale, Vector3f tempVec) {
        float f = PlayerAnimationHelper.getRunningSeconds(animation, runningTime);
        animation.f_232257_().forEach((key, list) -> {
            Optional<ModelPart> optional = PlayerAnimationHelper.getChild(model, key);
            optional.ifPresent(ModelPart::m_233569_);
            optional.ifPresent(part -> list.forEach(transformation -> {
                Keyframe[] keyframes = transformation.f_232212_();
                int i = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, index -> f <= keyframes[index].f_232283_()) - 1);
                int j = Math.min(keyframes.length - 1, i + 1);
                Keyframe keyframe = keyframes[i];
                Keyframe keyframe2 = keyframes[j];
                float h = f - keyframe.f_232283_();
                float k = j != i ? Mth.m_14036_((float)(h / (keyframe2.f_232283_() - keyframe.f_232283_())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe2.f_232285_().m_232222_(tempVec, k, keyframes, i, j, scale);
                transformation.f_232211_().m_232247_(part, tempVec);
            }));
        });
        PlayerAnimationHelper.correctSleevies(model);
    }

    private static void correctSleevies(PlayerModel<?> model) {
        model.f_102809_.m_104315_(model.f_102808_);
        model.f_103374_.m_104315_(model.f_102812_);
        model.f_103375_.m_104315_(model.f_102811_);
        model.f_103376_.m_104315_(model.f_102814_);
        model.f_103377_.m_104315_(model.f_102813_);
        model.f_103378_.m_104315_(model.f_102810_);
    }

    public static void updateAnimation(AnimationState animationState, AnimationDefinition animation, float animationProgress, float speedMultiplier, PlayerModel<?> model) {
        animationState.m_216974_(animationProgress, speedMultiplier);
        animationState.m_216979_(state -> PlayerAnimationHelper.animate(model, animation, state.m_216981_(), 1.0f, new Vector3f()));
    }

    public static void updateAnimation(AnimationState animationState, AnimationDefinition animation, float animationProgress, PlayerModel<?> model) {
        PlayerAnimationHelper.updateAnimation(animationState, animation, animationProgress, 1.0f, model);
    }

    public static float getRunningSeconds(AnimationDefinition animation, long runningTime) {
        float f = (float)runningTime / 1000.0f;
        return animation.f_232256_() ? f % animation.f_232255_() : f;
    }

    private static Optional<ModelPart> getChild(PlayerModel<?> model, String name) {
        return ((PlayerModelHook)model).animation$getChild(name);
    }

    public static Vector3f getModelPartPivot(PlayerModel<?> model, String name) {
        Optional<ModelPart> optional = PlayerAnimationHelper.getChild(model, name);
        if (optional.isEmpty()) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        Vector3f pivot = new Vector3f(optional.get().f_104200_, optional.get().f_104201_, optional.get().f_104202_);
        return pivot;
    }

    public static Vector3f getModelPartRotation(PlayerModel<?> model, String name) {
        Optional<ModelPart> optional = PlayerAnimationHelper.getChild(model, name);
        if (optional.isEmpty()) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        Vector3f rotation = new Vector3f(optional.get().f_104200_, optional.get().f_104201_, optional.get().f_104202_);
        return rotation;
    }

    public static void runAnimations(AbstractClientPlayer livingEntity, PlayerModel<?> model, float progress) {
        PlayerAnimationHolder anim = (PlayerAnimationHolder)PlayerAnimationTracker.getInstance().get((LivingEntity)livingEntity);
        if (anim != null) {
            anim.update((EntityModel<?>)model, progress, (LivingEntity)livingEntity);
            return;
        }
    }

    public static void startAnimations(AbstractClientPlayer entity) {
    }

    public static boolean isRunningAnimations(AbstractClientPlayer livingEntity) {
        PlayerAnimationHolder anim = (PlayerAnimationHolder)PlayerAnimationTracker.getInstance().get((LivingEntity)livingEntity);
        return anim != null && !anim.isFinished((LivingEntity)livingEntity);
    }

    public static void playAnimation(AbstractClientPlayer player, ResourceLocation animation) {
        PlayerAnimationHelper.playAnimation(player, (PlayerAnimationHolder)AnimationRegistry.instance().get(animation).get());
    }

    public static void playAnimation(AbstractClientPlayer player, PlayerAnimationHolder holder) {
        PlayerAnimationHelper.stopAnimation(player);
        PlayerAnimationTracker.getInstance().add(player.m_20148_(), holder);
    }

    public static void stopAnimation(AbstractClientPlayer player) {
        PlayerAnimationTracker.getInstance().clear(player.m_20148_());
    }
}

