/*
 * Decompiled with CFR 0.152.
 */
package mc.duzo.animation.mixin;

import java.util.List;
import java.util.Optional;
import mc.duzo.animation.generic.AnimationInfo;
import mc.duzo.animation.player.PlayerAnimationHelper;
import mc.duzo.animation.player.PlayerModelHook;
import mc.duzo.animation.util.AnimationUtil;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerEntityModelMixin<T extends LivingEntity>
extends HumanoidModel<T>
implements PlayerModelHook {
    @Shadow
    @Final
    private List<ModelPart> f_170815_;
    @Unique
    ModelPart root;

    public PlayerEntityModelMixin(ModelPart root) {
        super(root);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void animation$init(ModelPart root, boolean thinArms, CallbackInfo ci) {
        this.root = root;
    }

    @Inject(method={"setAngles(Lnet/minecraft/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
    public void animation$setAngles(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (!(livingEntity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
        PlayerAnimationHelper.startAnimations(player);
        if (!AnimationUtil.isRunningAnimations(player)) {
            return;
        }
        if (AnimationUtil.getInfo(player).transform() == AnimationInfo.Transform.ALL) {
            this.animation$getPart().m_233569_();
            this.f_170815_.forEach(ModelPart::m_233569_);
        }
        PlayerModel model = (PlayerModel)this;
        PlayerAnimationHelper.runAnimations(player, model, h);
    }

    @Override
    public Optional<ModelPart> animation$getChild(String name) {
        if (name.equals("root") || name.equalsIgnoreCase("player")) {
            return Optional.of(this.animation$getPart());
        }
        return this.animation$getPart().m_171331_().filter(part -> part.m_233562_(name)).findFirst().map(part -> part.m_171324_(name));
    }

    @Override
    public ModelPart animation$getPart() {
        return this.root;
    }
}

