/*
 * Decompiled with CFR 0.152.
 */
package mc.duzo.animation.generic;

import java.util.HashMap;
import java.util.UUID;
import mc.duzo.animation.DuzoAnimationMod;
import mc.duzo.animation.generic.AnimationHolder;
import mc.duzo.animation.registry.Identifiable;
import mc.duzo.animation.registry.client.TrackerRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public abstract class AnimationTracker<T extends AnimationHolder>
implements Identifiable {
    private final ResourceLocation id;
    protected final HashMap<UUID, T> animations = new HashMap();

    protected AnimationTracker(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    public T get(LivingEntity entity) {
        UUID uuid = entity.m_20148_();
        AnimationHolder anim = (AnimationHolder)this.animations.get(uuid);
        if (anim != null && anim.isFinished(entity)) {
            this.clear(uuid);
            return null;
        }
        return (T)anim;
    }

    public void add(UUID uuid, T animation) {
        this.animations.put(uuid, animation);
    }

    public void clear(UUID uuid) {
        this.animations.remove(uuid);
    }

    public void play(ServerPlayer player, ResourceLocation animation) {
        DuzoAnimationMod.play(player, this, animation);
    }

    public void onDisconnect() {
        this.animations.clear();
    }

    public AnimationTracker<T> register() {
        return TrackerRegistry.register(this);
    }
}

