/*
 * Decompiled with CFR 0.152.
 */
package mc.duzo.animation.generic;

import mc.duzo.animation.generic.AnimationInfo;
import mc.duzo.animation.generic.VisibilityList;
import mc.duzo.animation.player.PlayerAnimationHelper;
import mc.duzo.animation.registry.Identifiable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.EntityModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;

public abstract class AnimationHolder
implements Identifiable {
    private final ResourceLocation id;
    protected final AnimationState state;
    protected final AnimationDefinition animation;
    protected final AnimationInfo info;

    protected AnimationHolder(ResourceLocation id, AnimationDefinition anim, AnimationInfo info) {
        this.id = id;
        this.state = new AnimationState();
        this.animation = anim;
        this.info = info;
    }

    protected AnimationHolder(ResourceLocation id, AnimationDefinition anim) {
        this(id, anim, new AnimationInfo(VisibilityList.all(), AnimationInfo.Perspective.THIRD_PERSON_FRONT, AnimationInfo.Movement.DISABLE, AnimationInfo.Transform.ALL));
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    public void update(EntityModel<?> model, float progress, LivingEntity player) {
        if (this.isFinished(player)) {
            this.state.m_216973_();
            this.onFinished(player);
            return;
        }
        if (!this.state.m_216984_()) {
            this.onStart(player);
        }
        this.state.m_216982_(player.f_19797_);
    }

    public boolean isFinished(LivingEntity entity) {
        if (this.animation.f_232256_()) {
            return false;
        }
        return this.getRunningSeconds() >= this.animation.f_232255_();
    }

    protected void onFinished(LivingEntity player) {
    }

    protected void onStart(LivingEntity player) {
    }

    protected float getRunningSeconds() {
        return PlayerAnimationHelper.getRunningSeconds(this.animation, this.state.m_216981_());
    }

    public AnimationDefinition getAnimation() {
        return this.animation;
    }

    public AnimationInfo getInfo() {
        return this.info;
    }
}

