/*
 * Decompiled with CFR 0.152.
 */
package mc.duzo.animation.api;

import java.util.Optional;
import mc.duzo.animation.generic.AnimationInfo;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.client.player.AbstractClientPlayer;

public final class AnimationEvents {
    public static final Event<FindAnimationInfo> FIND_ANIMATION_INFO = EventFactory.createArrayBacked(FindAnimationInfo.class, callbacks -> player -> {
        for (FindAnimationInfo callback : callbacks) {
            Result<AnimationInfo> value = callback.getAnimationInfo(player);
            if (value.type() == Interaction.PASS && !value.result().isPresent()) continue;
            return value;
        }
        return Result.success();
    });

    @FunctionalInterface
    public static interface FindAnimationInfo {
        public Result<AnimationInfo> getAnimationInfo(AbstractClientPlayer var1);
    }

    public record Result<T>(Interaction type, Optional<T> t) {
        public Result(Interaction inter) {
            this(inter, Optional.empty());
        }

        public Result(T t) {
            this(Interaction.PASS, t);
        }

        public Result(Interaction inter, T t) {
            this(inter, Optional.ofNullable(t));
        }

        public static <T> Result<T> success() {
            return new Result<T>(Interaction.SUCCESS);
        }

        public static <T> Result<T> fail() {
            return new Result<T>(Interaction.FAIL);
        }

        public static <T> Result<T> pass() {
            return new Result<T>(Interaction.PASS);
        }

        public Optional<T> result() {
            return this.t;
        }
    }

    public static enum Interaction {
        SUCCESS,
        FAIL,
        PASS;

    }
}

