/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.scheduler.api.common;

import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.task.Task;
import net.minecraft.server.level.ServerLevel;

@FunctionalInterface
public interface TaskStage {
    public static final TaskStage END_SERVER_TICK = (scheduler, task) -> scheduler.endServerTickTasks.add(task);
    public static final TaskStage START_SERVER_TICK = (scheduler, task) -> scheduler.startServerTickTasks.add(task);

    public static TaskStage startWorldTick(ServerLevel world) {
        return (scheduler, task) -> Scheduler.getDeque(world, scheduler.startWorldTickTasks).add(task);
    }

    public static TaskStage endWorldTick(ServerLevel world) {
        return (scheduler, task) -> Scheduler.getDeque(world, scheduler.endWorldTickTasks).add(task);
    }

    public void apply(Scheduler var1, Task<?> var2);

    default public Task<?> add(Scheduler scheduler, Task<?> task) {
        this.apply(scheduler, task);
        return task;
    }
}

