/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.scheduler.api.common;

import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.TaskStage;
import dev.drtheo.scheduler.api.task.AsyncRepeatingSimpleTask;
import dev.drtheo.scheduler.api.task.AsyncSimpleTask;
import dev.drtheo.scheduler.api.task.RepeatingSimpleTask;
import dev.drtheo.scheduler.api.task.SimpleTask;
import dev.drtheo.scheduler.api.task.Task;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;

public class Scheduler {
    private static final ExecutorService service = Util.m_183991_();
    protected final Deque<Task<?>> endServerTickTasks = new ConcurrentLinkedDeque();
    protected final Deque<Task<?>> startServerTickTasks = new ConcurrentLinkedDeque();
    protected final IdentityHashMap<ServerLevel, Deque<Task<?>>> startWorldTickTasks = new IdentityHashMap();
    protected final IdentityHashMap<ServerLevel, Deque<Task<?>>> endWorldTickTasks = new IdentityHashMap();
    private static Scheduler self;

    private Scheduler() {
        ServerTickEvents.START_WORLD_TICK.register(world -> Scheduler.tickMap(world, this.startWorldTickTasks));
        ServerTickEvents.END_WORLD_TICK.register(world -> Scheduler.tickMap(world, this.endWorldTickTasks));
        ServerTickEvents.END_SERVER_TICK.register(server -> this.endServerTickTasks.removeIf(Task::tick));
        ServerTickEvents.END_SERVER_TICK.register(server -> this.startServerTickTasks.removeIf(Task::tick));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            this.endServerTickTasks.clear();
            this.startServerTickTasks.clear();
            this.startWorldTickTasks.clear();
            this.endWorldTickTasks.clear();
        });
    }

    private static void tickMap(ServerLevel world, Map<ServerLevel, Deque<Task<?>>> taskMap) {
        Deque<Task<?>> tasks = taskMap.get(world);
        if (tasks == null) {
            return;
        }
        tasks.removeIf(Task::tick);
    }

    protected static Deque<Task<?>> getDeque(ServerLevel world, Map<ServerLevel, Deque<Task<?>>> taskMap) {
        return taskMap.computeIfAbsent(world, w -> new ConcurrentLinkedDeque());
    }

    public static void init() {
        if (self != null) {
            return;
        }
        self = new Scheduler();
    }

    public Task<?> runTaskLater(Runnable runnable, TaskStage stage, TimeUnit unit, long delay) {
        return stage.add(this, new SimpleTask(runnable, TimeUnit.TICKS.from(unit, delay)));
    }

    public Task<?> runAsyncTaskLater(Runnable runnable, TaskStage stage, TimeUnit unit, long delay) {
        return stage.add(this, new AsyncSimpleTask(service, runnable, TimeUnit.TICKS.from(unit, delay)));
    }

    public Task<?> runTaskTimer(Consumer<Task<?>> runnable, TaskStage stage, TimeUnit unit, long period) {
        return stage.add(this, new RepeatingSimpleTask(runnable, TimeUnit.TICKS.from(unit, period)));
    }

    public Task<?> runAsyncTaskTimer(Consumer<Task<?>> runnable, TaskStage stage, TimeUnit unit, long period) {
        return stage.add(this, new AsyncRepeatingSimpleTask(service, runnable, TimeUnit.TICKS.from(unit, period)));
    }

    public static Scheduler get() {
        return self;
    }
}

