/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.queue.api.util.structure;

import com.mojang.datafixers.util.Pair;
import dev.drtheo.queue.api.ActionQueue;
import dev.drtheo.queue.mixin.StructureTemplateAccessor;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import org.jetbrains.annotations.Nullable;

public class QueuedStructureTemplate {
    private static final Direction[] directions = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final List<StructureTemplate.Palette> blockInfoLists;
    private final List<StructureTemplate.StructureEntityInfo> entities;
    private final Vec3i size;

    public QueuedStructureTemplate(StructureTemplate template) {
        this((StructureTemplateAccessor)template);
    }

    private QueuedStructureTemplate(StructureTemplateAccessor accessor) {
        this.blockInfoLists = accessor.getBlockInfo();
        this.entities = accessor.getEntities();
        this.size = accessor.getSize();
    }

    public Optional<ActionQueue> place(ServerLevelAccessor world, BlockPos pos, BlockPos pivot, StructurePlaceSettings placementData, RandomSource random, int flags) {
        if (this.blockInfoLists.isEmpty()) {
            return Optional.empty();
        }
        List randomBlocks = placementData.m_74387_(this.blockInfoLists, pos).m_74652_();
        ArrayList flowingFluid = new ArrayList(placementData.m_74413_() ? randomBlocks.size() : 0);
        ArrayList stillFluid = new ArrayList(placementData.m_74413_() ? randomBlocks.size() : 0);
        if (randomBlocks.isEmpty() && (placementData.m_74408_() || this.entities.isEmpty()) || this.size.m_123341_() < 1 || this.size.m_123342_() < 1 || this.size.m_123343_() < 1) {
            return Optional.empty();
        }
        BoundingBox blockBox = placementData.m_74409_();
        ArrayList nbtList = new ArrayList(randomBlocks.size());
        Object ctx = new Object(){
            int x1 = Integer.MAX_VALUE;
            int y1 = Integer.MAX_VALUE;
            int z1 = Integer.MAX_VALUE;
            int x2 = Integer.MIN_VALUE;
            int y2 = Integer.MIN_VALUE;
            int z2 = Integer.MIN_VALUE;
        };
        List processedBlocks = StructureTemplate.m_74517_((ServerLevelAccessor)world, (BlockPos)pos, (BlockPos)pivot, (StructurePlaceSettings)placementData, (List)randomBlocks);
        Iterator blockInfoIter = processedBlocks.iterator();
        return Optional.of(new ActionQueue().thenRunSteps(() -> this.lambda$place$0(blockInfoIter, blockBox, placementData, world, flags, ctx, nbtList, random, stillFluid, flowingFluid), TaskStage.startWorldTick(world.m_6018_()), TimeUnit.TICKS, 1, 20).thenRun(() -> this.lambda$place$1(world, flowingFluid, stillFluid, ctx, placementData, nbtList, flags, pos, blockBox)));
    }

    protected void readNbt(BlockEntity blockEntity, CompoundTag nbt, RandomSource random) {
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            nbt.m_128356_("LootTableSeed", random.m_188505_());
        }
        blockEntity.m_142466_(nbt);
    }

    private void update(ServerLevelAccessor world, StructurePlaceSettings placementData, List<Pair<BlockPos, CompoundTag>> nbtList, int x1, int y1, int z1, int x2, int y2, int z2, int flags) {
        if (!placementData.m_74410_()) {
            BitSetDiscreteVoxelShape voxelSet = new BitSetDiscreteVoxelShape(x2 - x1 + 1, y2 - y1 + 1, z2 - z1 + 1);
            for (Pair<BlockPos, CompoundTag> pair : nbtList) {
                BlockPos pos = (BlockPos)pair.getFirst();
                voxelSet.m_142703_(pos.m_123341_() - x1, pos.m_123342_() - y1, pos.m_123343_() - z1);
            }
            StructureTemplate.m_74510_((LevelAccessor)world, (int)flags, (DiscreteVoxelShape)voxelSet, (int)x1, (int)y1, (int)z1);
        }
        for (Pair<BlockPos, CompoundTag> pair : nbtList) {
            BlockPos pos = (BlockPos)pair.getFirst();
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!placementData.m_74410_()) {
                BlockState processedState;
                BlockState originalState = world.m_8055_(pos);
                if (originalState != (processedState = Block.m_49931_((BlockState)originalState, (LevelAccessor)world, (BlockPos)pos))) {
                    world.m_7731_(pos, processedState, flags & 0xFFFFFFFE | 0x10);
                }
                world.m_6289_(pos, processedState.m_60734_());
            }
            if (pair.getSecond() == null || blockEntity == null) continue;
            blockEntity.m_6596_();
        }
    }

    private void fillWithFluid(ServerLevelAccessor world, List<BlockPos> flowing, List<BlockPos> still) {
        boolean shouldContinue = true;
        while (shouldContinue && !flowing.isEmpty()) {
            shouldContinue = false;
            for (BlockPos blockPos : flowing) {
                BlockState blockState = world.m_8055_(blockPos);
                FluidState fluidState = world.m_6425_(blockPos);
                Block block = blockState.m_60734_();
                if (!(block instanceof LiquidBlockContainer)) continue;
                LiquidBlockContainer fillable = (LiquidBlockContainer)block;
                for (int o = 0; o < directions.length && !fluidState.m_76170_(); ++o) {
                    BlockPos offsetPos = blockPos.m_121945_(directions[o]);
                    FluidState offsetFluidState = world.m_6425_(offsetPos);
                    if (!offsetFluidState.m_76170_() || still.contains(offsetPos)) continue;
                    fluidState = offsetFluidState;
                }
                if (!fluidState.m_76170_()) continue;
                fillable.m_7361_((LevelAccessor)world, blockPos, blockState, fluidState);
                shouldContinue = true;
            }
        }
    }

    private void spawnEntities(ServerLevelAccessor world, BlockPos pos, Mirror mirror, Rotation rotation, BlockPos pivot, @Nullable BoundingBox area, boolean initializeMobs) {
        for (StructureTemplate.StructureEntityInfo structureEntityInfo : this.entities) {
            BlockPos blockPos = StructureTemplate.m_74593_((BlockPos)structureEntityInfo.f_74684_, (Mirror)mirror, (Rotation)rotation, (BlockPos)pivot).m_121955_((Vec3i)pos);
            if (area != null && !area.m_71051_((Vec3i)blockPos)) continue;
            CompoundTag nbtCompound = structureEntityInfo.f_74685_.m_6426_();
            Vec3 vec3d = StructureTemplate.m_74578_((Vec3)structureEntityInfo.f_74683_, (Mirror)mirror, (Rotation)rotation, (BlockPos)pivot);
            Vec3 vec3d2 = vec3d.m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            ListTag nbtList = new ListTag();
            nbtList.add((Object)DoubleTag.m_128500_((double)vec3d2.f_82479_));
            nbtList.add((Object)DoubleTag.m_128500_((double)vec3d2.f_82480_));
            nbtList.add((Object)DoubleTag.m_128500_((double)vec3d2.f_82481_));
            nbtCompound.m_128365_("Pos", (Tag)nbtList);
            nbtCompound.m_128473_("UUID");
            QueuedStructureTemplate.getEntity(world, nbtCompound).ifPresent(entity -> {
                float yaw = entity.m_7890_(rotation) + entity.m_6961_(mirror) - entity.m_146908_();
                entity.m_7678_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, yaw, entity.m_146909_());
                if (initializeMobs && entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_6518_(world, world.m_6436_(BlockPos.m_274446_((Position)vec3d2)), MobSpawnType.STRUCTURE, null, nbtCompound);
                }
                world.m_47205_(entity);
            });
        }
    }

    private static Optional<Entity> getEntity(ServerLevelAccessor world, CompoundTag nbt) {
        try {
            return EntityType.m_20642_((CompoundTag)nbt, (Level)world.m_6018_());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private /* synthetic */ void lambda$place$1(ServerLevelAccessor world, List flowingFluid, List stillFluid, 1 ctx, StructurePlaceSettings placementData, List nbtList, int flags, BlockPos pos, BoundingBox blockBox) {
        this.fillWithFluid(world, flowingFluid, stillFluid);
        if (ctx.x1 <= ctx.x2) {
            this.update(world, placementData, nbtList, ctx.x1, ctx.y1, ctx.z1, ctx.x2, ctx.y2, ctx.z2, flags);
        }
        if (!placementData.m_74408_()) {
            this.spawnEntities(world, pos, placementData.m_74401_(), placementData.m_74404_(), placementData.m_74407_(), blockBox, placementData.m_74414_());
        }
    }

    private /* synthetic */ Boolean lambda$place$0(Iterator blockInfoIter, BoundingBox blockBox, StructurePlaceSettings placementData, ServerLevelAccessor world, int flags, 1 ctx, List nbtList, RandomSource random, List stillFluid, List flowingFluid) {
        if (!blockInfoIter.hasNext()) {
            return true;
        }
        StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)blockInfoIter.next();
        BlockPos blockPos = blockInfo.f_74675_();
        if (blockBox != null && !blockBox.m_71051_((Vec3i)blockPos)) {
            return false;
        }
        FluidState fluidState = placementData.m_74413_() ? world.m_6425_(blockPos) : null;
        BlockState blockState = blockInfo.f_74676_().m_60715_(placementData.m_74401_()).m_60717_(placementData.m_74404_());
        if (blockInfo.f_74677_() != null) {
            Clearable.m_18908_((Object)world.m_7702_(blockPos));
        }
        world.m_7731_(blockPos, blockState, flags);
        ctx.x1 = Math.min(ctx.x1, blockPos.m_123341_());
        ctx.y1 = Math.min(ctx.y1, blockPos.m_123342_());
        ctx.z1 = Math.min(ctx.z1, blockPos.m_123343_());
        ctx.x2 = Math.max(ctx.x2, blockPos.m_123341_());
        ctx.y2 = Math.max(ctx.y2, blockPos.m_123342_());
        ctx.z2 = Math.max(ctx.z2, blockPos.m_123343_());
        nbtList.add(Pair.of((Object)blockPos, (Object)blockInfo.f_74677_()));
        BlockEntity blockEntity = world.m_7702_(blockPos);
        if (blockInfo.f_74677_() != null && blockEntity != null) {
            this.readNbt(blockEntity, blockInfo.f_74677_(), random);
        }
        if (fluidState == null) {
            return false;
        }
        if (blockState.m_60819_().m_76170_()) {
            stillFluid.add(blockPos);
            return false;
        }
        Block patt5243$temp = blockState.m_60734_();
        if (!(patt5243$temp instanceof LiquidBlockContainer)) {
            return false;
        }
        LiquidBlockContainer fillable = (LiquidBlockContainer)patt5243$temp;
        fillable.m_7361_((LevelAccessor)world, blockPos, blockState, fluidState);
        if (fluidState.m_76170_()) {
            return false;
        }
        flowingFluid.add(blockPos);
        return false;
    }
}

