/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.queue.api.util.block;

import dev.drtheo.queue.api.ActionQueue;
import dev.drtheo.queue.api.util.block.BlockData;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockQueue {
    public ActionQueue schedulePlace(ServerLevel world, TimeUnit unit, int period, int maxTime, int flags) {
        return this.schedulePlace(new ActionQueue(), world, unit, period, maxTime, flags);
    }

    public ActionQueue schedulePlace(ActionQueue queue, ServerLevel world, TimeUnit unit, int period, int maxTime, int flags) {
        return queue.thenRunSteps(() -> {
            BlockData block = this.pollBlock();
            if (block == null) {
                return true;
            }
            int blockFlags = block.flags() == -1 ? flags : block.flags();
            world.m_7731_(block.pos(), block.state(), blockFlags);
            return false;
        }, TaskStage.startWorldTick(world), unit, period, maxTime);
    }

    protected abstract BlockData pollBlock();

    public static class Simple
    extends BlockQueue {
        private final Deque<BlockData> blocks = new ArrayDeque<BlockData>();

        @Override
        protected BlockData pollBlock() {
            return this.blocks.poll();
        }

        public void set(BlockPos pos, BlockState state) {
            this.set(pos, state, -1);
        }

        public void set(BlockPos pos, BlockState state, int flags) {
            this.blocks.add(new BlockData(state, pos, flags));
        }
    }
}

