/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.multidim.mixin;

import com.google.common.collect.Maps;
import dev.drtheo.multidim.MultiDimMod;
import dev.drtheo.multidim.api.MultiDimServer;
import dev.drtheo.multidim.event.ServerCrashEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.CrashReport;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements MultiDimServer {
    @Shadow
    @Final
    protected LevelStorageSource.LevelStorageAccess f_129744_;
    @Shadow
    @Final
    @Mutable
    private Map<ResourceKey<Level>, ServerLevel> f_129762_;

    @Override
    public void multidim$addWorld(ServerLevel world) {
        LinkedHashMap newMap = Maps.newLinkedHashMap();
        Map<ResourceKey<Level>, ServerLevel> oldMap = this.f_129762_;
        newMap.putAll(oldMap);
        newMap.put(world.m_46472_(), world);
        this.f_129762_ = newMap;
    }

    @Override
    public boolean multidim$hasWorld(ResourceKey<Level> key) {
        return this.f_129762_.containsKey(key);
    }

    @Override
    public ServerLevel multidim$removeWorld(ResourceKey<Level> key) {
        LinkedHashMap newMap = Maps.newLinkedHashMap();
        Map<ResourceKey<Level>, ServerLevel> oldMap = this.f_129762_;
        for (Map.Entry<ResourceKey<Level>, ServerLevel> entry : oldMap.entrySet()) {
            if (entry.getKey() == key) continue;
            newMap.put(entry.getKey(), entry.getValue());
        }
        this.f_129762_ = newMap;
        return oldMap.get(key);
    }

    @Override
    public LevelStorageSource.LevelStorageAccess multidim$getSession() {
        return this.f_129744_;
    }

    @Inject(method={"setCrashReport"}, at={@At(value="TAIL")})
    private void ait$setCrashReport(CrashReport report, CallbackInfo info) {
        MultiDimMod.LOGGER.error("Crash Detected - nice one m8");
        ((ServerCrashEvent.Crash)ServerCrashEvent.EVENT.invoker()).onServerCrash((MinecraftServer)this, report);
    }
}

