/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.multidim.api;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import dev.drtheo.multidim.api.MultiDimServer;
import dev.drtheo.multidim.api.MultiDimServerWorld;
import dev.drtheo.multidim.impl.AbstractWorldGenListener;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.jetbrains.annotations.Nullable;

public class WorldBlueprint {
    private final ResourceLocation id;
    private long seed;
    private boolean tickTime = true;
    private ResourceLocation typeId;
    private DimensionType type;
    private WorldCreator creator = MultiDimServerWorld::new;
    private ChunkGenerator generator;
    private boolean autoLoad = true;
    private boolean persistent = true;
    private LevelStem options;

    public WorldBlueprint(ResourceLocation id) {
        this.id = id;
    }

    public WorldBlueprint withSeed(long seed) {
        this.seed = BiomeManager.m_47877_((long)seed);
        return this;
    }

    public long seed() {
        return this.seed;
    }

    public WorldBlueprint withCreator(WorldCreator creator) {
        this.creator = creator;
        return this;
    }

    public WorldBlueprint withType(ResourceLocation id) {
        this.typeId = id;
        return this;
    }

    public WorldBlueprint withType(DimensionType type) {
        return this.withType(null, type);
    }

    public WorldBlueprint withType(ResourceLocation id, DimensionType type) {
        this.typeId = id;
        this.type = type;
        return this;
    }

    public WorldBlueprint withGenerator(ChunkGenerator generator) {
        this.generator = generator;
        return this;
    }

    public WorldBlueprint shouldTickTime(boolean tickTime) {
        this.tickTime = tickTime;
        return this;
    }

    public boolean shouldTickTime() {
        return this.tickTime;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public WorldBlueprint setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public WorldBlueprint setAutoLoad(boolean autoLoad) {
        this.autoLoad = autoLoad;
        return this;
    }

    public boolean autoLoad() {
        return this.autoLoad;
    }

    public MultiDimServerWorld createWorld(MinecraftServer server, ResourceKey<Level> key, LevelStem options, boolean created) {
        WorldData saveProps = server.m_129910_();
        return this.creator.create(this, server, Util.m_183991_(), ((MultiDimServer)server).multidim$getSession(), (ServerLevelData)new DerivedLevelData(saveProps, saveProps.m_5996_()), key, options, new AbstractWorldGenListener(), (List<CustomSpawner>)ImmutableList.of(), null, created);
    }

    private Holder<DimensionType> resolveType(MinecraftServer server) {
        MappedRegistry typeRegistry = (MappedRegistry)server.m_206579_().m_175515_(Registries.f_256787_);
        if (this.typeId == null) {
            this.typeId = this.id;
        }
        ResourceKey typeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)this.typeId);
        if (this.type == null) {
            Holder entry = typeRegistry.m_203636_(typeKey).orElse(null);
            if (entry == null) {
                return null;
            }
            this.type = (DimensionType)entry.m_203334_();
            return entry;
        }
        if (!typeRegistry.m_142003_(typeKey)) {
            return typeRegistry.m_255290_(typeKey, (Object)this.type, Lifecycle.stable());
        }
        return typeRegistry.m_203636_(typeKey).orElse(null);
    }

    public LevelStem createOptions(MinecraftServer server) {
        if (this.options != null) {
            return this.options;
        }
        Holder<DimensionType> typeEntry = this.resolveType(server);
        if (typeEntry == null) {
            throw new IllegalArgumentException("Dimension type is required to create dimension options!");
        }
        return new LevelStem(typeEntry, this.generator);
    }

    public static interface WorldCreator {
        public MultiDimServerWorld create(WorldBlueprint var1, MinecraftServer var2, Executor var3, LevelStorageSource.LevelStorageAccess var4, ServerLevelData var5, ResourceKey<Level> var6, LevelStem var7, ChunkProgressListener var8, List<CustomSpawner> var9, @Nullable RandomSequences var10, boolean var11);
    }
}

