/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.multidim;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.drtheo.multidim.MultiDim;
import dev.drtheo.multidim.MultiDimMod;
import dev.drtheo.multidim.api.MultiDimServerWorld;
import dev.drtheo.multidim.api.WorldBlueprint;
import dev.drtheo.multidim.event.ServerCrashEvent;
import dev.drtheo.multidim.event.WorldSaveEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public class MultiDimFileManager {
    private static final Gson gson = new Gson();

    public static Path getRootSavePath(Path root) {
        return root.resolve(".multidim2");
    }

    public static Path getRootSavePath(MinecraftServer server) {
        return MultiDimFileManager.getRootSavePath(server.m_129843_(LevelResource.f_78182_));
    }

    public static Path getSavePath(MinecraftServer server, ResourceLocation id) {
        return MultiDimFileManager.getRootSavePath(server).resolve(id.m_135827_()).resolve(id.m_135815_() + ".json");
    }

    public static void init() {
        ServerCrashEvent.EVENT.register((server, report) -> {
            for (ServerLevel world : server.m_129785_()) {
                MultiDimFileManager.writeIfNeeded(server, world);
            }
        });
        WorldSaveEvent.EVENT.register(world -> MultiDimFileManager.writeIfNeeded(world.m_7654_(), world));
        ServerLifecycleEvents.SERVER_STARTED.register(MultiDimFileManager::readAll);
    }

    public static void writeIfNeeded(MinecraftServer server, ServerLevel world) {
        MultiDimServerWorld msw;
        if (world instanceof MultiDimServerWorld && (msw = (MultiDimServerWorld)world).getBlueprint().persistent()) {
            MultiDimFileManager.write(server, msw);
        }
    }

    public static void write(MinecraftServer server, MultiDimServerWorld world) {
        ResourceKey key = world.m_46472_();
        Path file = MultiDimFileManager.getSavePath(server, key.m_135782_());
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
            JsonObject root = new JsonObject();
            root.addProperty("blueprint", world.getBlueprint().id().toString());
            Files.writeString(file, (CharSequence)gson.toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (IOException e) {
            MultiDimMod.LOGGER.warn("Couldn't create world file! {}", (Object)key.m_135782_(), (Object)e);
        }
    }

    public static void readAll(MinecraftServer server) {
        if (server == null || !server.m_130010_()) {
            return;
        }
        Path root = MultiDimFileManager.getRootSavePath(server);
        if (!Files.exists(root, new LinkOption[0])) {
            return;
        }
        MultiDim multidim = MultiDim.get(server);
        try (Stream<Path> stream = Files.list(root);){
            stream.forEach(namespace -> {
                if (!Files.isDirectory(namespace, new LinkOption[0])) {
                    return;
                }
                MultiDimFileManager.readNamespace(multidim, namespace);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void readNamespace(MultiDim multidim, Path namespace) {
        try (Stream<Path> stream = Files.list(namespace);){
            stream.forEach(file -> {
                Saved saved = MultiDimFileManager.readFromFile(multidim, namespace.getFileName().toString(), file);
                if (saved == null) {
                    MultiDimMod.LOGGER.warn("Failed to load world from file {}", file);
                    return;
                }
                WorldBlueprint blueprint = multidim.getBlueprint(saved.blueprint);
                if (blueprint.persistent() && blueprint.autoLoad()) {
                    multidim.load(blueprint, saved.world);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Saved readFromFile(MultiDim multidim, String namespace, Path file) {
        String fileName = file.getFileName().toString();
        ResourceLocation id = new ResourceLocation(namespace, fileName.substring(0, fileName.length() - 5));
        return MultiDimFileManager.read(multidim.server, id);
    }

    private static Saved read(MinecraftServer server, ResourceLocation id) {
        Path file = MultiDimFileManager.getSavePath(server, id);
        try {
            JsonObject element = JsonParser.parseString((String)Files.readString(file)).getAsJsonObject();
            ResourceLocation blueprint = ResourceLocation.m_135820_((String)element.get("blueprint").getAsString());
            return new Saved(blueprint, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id));
        }
        catch (Throwable e) {
            MultiDimMod.LOGGER.warn("Couldn't read world file! {}", (Object)id, (Object)e);
            return null;
        }
    }

    public record Saved(ResourceLocation blueprint, ResourceKey<Level> world) {
    }
}

