/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.multidim;

import com.mojang.serialization.Lifecycle;
import dev.drtheo.multidim.MultiDimFileManager;
import dev.drtheo.multidim.MultiDimMod;
import dev.drtheo.multidim.api.MultiDimServer;
import dev.drtheo.multidim.api.MultiDimServerWorld;
import dev.drtheo.multidim.api.MutableRegistry;
import dev.drtheo.multidim.api.WorldBlueprint;
import dev.drtheo.multidim.impl.SimpleWorldProgressListener;
import dev.drtheo.multidim.util.MultiDimUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.io.FileUtils;

public class MultiDim {
    private static MultiDim instance;
    private static boolean initialized;
    private final Map<ResourceLocation, WorldBlueprint> blueprints = new HashMap<ResourceLocation, WorldBlueprint>();
    protected final MinecraftServer server;
    private final Set<ServerLevel> toDelete = new ReferenceOpenHashSet();
    private final Set<ServerLevel> toUnload = new ReferenceOpenHashSet();

    public static void init() {
        if (initialized) {
            return;
        }
        MultiDimFileManager.init();
        ServerTickEvents.START_SERVER_TICK.register(server -> MultiDim.get(server).tick());
        initialized = true;
    }

    private MultiDim(MinecraftServer server) {
        this.server = server;
    }

    private void tick() {
        Set<ServerLevel> unloadingQueue;
        Set<ServerLevel> deletionQueue = this.toDelete;
        if (!deletionQueue.isEmpty()) {
            deletionQueue.removeIf(this::tickDeleteWorld);
        }
        if (!(unloadingQueue = this.toUnload).isEmpty()) {
            unloadingQueue.removeIf(this::tickUnloadWorld);
        }
    }

    public boolean isWorldUnloaded(ServerLevel world) {
        return world.m_6907_().isEmpty() && world.m_7726_().m_8482_() <= 0;
    }

    private boolean prepareForUnload(ServerLevel world) {
        if (this.isWorldUnloaded(world)) {
            return true;
        }
        this.kickPlayers(world);
        return false;
    }

    public void kickPlayers(ServerLevel world) {
        if (world.m_6907_().isEmpty()) {
            return;
        }
        ServerLevel overworld = this.server.m_129783_();
        Vec3 spawnPos = overworld.m_220360_().m_252807_();
        for (ServerPlayer player : world.m_6907_()) {
            player.m_8999_(overworld, spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), player.m_146908_(), player.m_146909_());
        }
    }

    private boolean tickDeleteWorld(ServerLevel world) {
        if (!this.prepareForUnload(world)) {
            return false;
        }
        this.remove((ResourceKey<Level>)world.m_46472_());
        return true;
    }

    private boolean tickUnloadWorld(ServerLevel world) {
        if (!this.prepareForUnload(world)) {
            return false;
        }
        this.unload((ResourceKey<Level>)world.m_46472_());
        return true;
    }

    public void register(WorldBlueprint blueprint) {
        this.blueprints.put(blueprint.id(), blueprint);
    }

    public static MultiDim get(MinecraftServer server) {
        MultiDim.init();
        if (instance == null || MultiDim.instance.server != server) {
            instance = new MultiDim(server);
        }
        return instance;
    }

    public MultiDimServerWorld add(WorldBlueprint blueprint, ResourceLocation id) {
        return this.addOrLoad(blueprint, id, true);
    }

    public MultiDimServerWorld load(WorldBlueprint blueprint, ResourceLocation id) {
        return this.addOrLoad(blueprint, id, false);
    }

    public MultiDimServerWorld addOrLoad(WorldBlueprint blueprint, ResourceLocation id, boolean created) {
        return this.addOrLoad(blueprint, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id), created);
    }

    public MultiDimServerWorld add(WorldBlueprint blueprint, ResourceKey<Level> id) {
        return this.addOrLoad(blueprint, id, true);
    }

    public MultiDimServerWorld load(WorldBlueprint blueprint, ResourceKey<Level> id) {
        return this.addOrLoad(blueprint, id, false);
    }

    public MultiDimServerWorld addOrLoad(WorldBlueprint blueprint, ResourceKey<Level> id, boolean created) {
        LevelStem options;
        ResourceKey key;
        ServerLevel existing = this.server.m_129880_(id);
        if (existing != null) {
            return (MultiDimServerWorld)existing;
        }
        MutableRegistry<LevelStem> dimensionsRegistry = MultiDimUtil.getMutableDimensionsRegistry(this.server);
        boolean wasFrozen = dimensionsRegistry.multidim$isFrozen();
        if (wasFrozen) {
            dimensionsRegistry.multidim$unfreeze();
        }
        if (!dimensionsRegistry.multidim$contains((ResourceKey<LevelStem>)(key = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)(options = blueprint.createOptions(this.server)).f_63975_().m_203543_().map(ResourceKey::m_135782_).orElse(blueprint.id()))))) {
            dimensionsRegistry.multidim$add((ResourceKey<LevelStem>)key, options, Lifecycle.stable());
        }
        if (wasFrozen) {
            dimensionsRegistry.multidim$freeze();
        }
        MultiDimServerWorld world = blueprint.createWorld(this.server, id, options, created);
        this.load(world);
        return world;
    }

    public void queueUnload(MultiDimServerWorld world) {
        this.toUnload.add(world);
    }

    public void queueUnload(ResourceKey<Level> key) {
        this.toUnload.add(this.server.m_129880_(key));
    }

    private void unload(ResourceKey<Level> key) {
        ServerLevel world = ((MultiDimServer)this.server).multidim$removeWorld(key);
        if (world == null) {
            return;
        }
        world.m_8643_((ProgressListener)new SimpleWorldProgressListener(() -> {
            MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)world));
            MultiDimUtil.getMutableDimensionsRegistry(this.server).multidim$remove(key.m_135782_());
        }), true, false);
    }

    public void queueRemove(MultiDimServerWorld world) {
        this.toDelete.add(world);
    }

    public void queueRemove(ResourceKey<Level> key) {
        this.toDelete.add(this.server.m_129880_(key));
    }

    private void remove(ResourceKey<Level> key) {
        ServerLevel world = ((MultiDimServer)this.server).multidim$removeWorld(key);
        if (world == null) {
            return;
        }
        ((ServerWorldEvents.Unload)ServerWorldEvents.UNLOAD.invoker()).onWorldUnload(this.server, world);
        MultiDimUtil.getMutableDimensionsRegistry(this.server).multidim$remove(key.m_135782_());
        LevelStorageSource.LevelStorageAccess session = ((MultiDimServer)this.server).multidim$getSession();
        File worldDirectory = session.m_197394_(key).toFile();
        if (!worldDirectory.exists()) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)worldDirectory);
        }
        catch (IOException e) {
            MultiDimMod.LOGGER.warn("Failed to delete world directory", (Throwable)e);
            try {
                FileUtils.forceDeleteOnExit((File)worldDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void load(MultiDimServerWorld world) {
        MultiDimMod.LOGGER.info("Loading world {}", (Object)world.m_46472_().m_135782_());
        if (((MultiDimServer)this.server).multidim$hasWorld((ResourceKey<Level>)world.m_46472_())) {
            MultiDimMod.LOGGER.warn("World {} is already loaded", (Object)world.m_46472_().m_135782_());
            return;
        }
        ((MultiDimServer)this.server).multidim$addWorld(world);
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)world));
        world.m_8793_(() -> true);
    }

    public WorldBlueprint getBlueprint(ResourceLocation id) {
        return this.blueprints.get(id);
    }

    static {
        initialized = false;
    }
}

