/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.util;

import dev.amble.lib.data.DirectedGlobalPos;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class TeleportUtil {
    public static void teleport(LivingEntity entity, DirectedGlobalPos pos) {
        TeleportUtil.teleport(entity, ServerLifecycleHooks.get().m_129880_(pos.getDimension()), pos.getPos().m_252807_(), pos.getRotationDegrees());
    }

    public static void teleport(LivingEntity entity, ServerLevel world, Vec3 pos, float yaw) {
        world.m_7654_().execute(() -> {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                TeleportUtil.teleportPlayer(player, world, pos, yaw, player.m_146909_());
                return;
            }
            TeleportUtil.teleportNonPlayer(entity, world, pos, yaw, entity.m_146909_());
        });
    }

    private static void teleportPlayer(ServerPlayer player, ServerLevel world, Vec3 pos, float yaw, float pitch) {
        player.m_8999_(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, yaw, pitch);
        player.m_6756_(0);
        player.m_21220_().forEach(effect -> player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), effect)));
        player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
    }

    private static void teleportNonPlayer(LivingEntity entity, ServerLevel world, Vec3 pos, float yaw, float pitch) {
        if (entity.m_9236_().m_46472_() == world.m_46472_()) {
            entity.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, yaw, pitch);
            return;
        }
        entity.m_264318_(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, Set.of(), yaw, pitch);
    }
}

