/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.util;

import dev.amble.lib.container.RegistryContainer;
import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReflectionUtil {
    public static <T, R extends RegistryContainer<T>, A extends Annotation> HashMap<T, Optional<A>> getAnnotatedValues(Class<R> parent, Class<T> value, Class<A> annotationClass, boolean inverse) {
        return Stream.of(parent.getDeclaredFields()).filter(field -> inverse != field.isAnnotationPresent(annotationClass)).filter(field -> value.isAssignableFrom(field.getType())).map(field -> {
            try {
                return new AbstractMap.SimpleEntry(field.get(null), inverse ? Optional.empty() : Optional.ofNullable(field.getAnnotation(annotationClass)));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(entry -> entry != null && entry.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, HashMap::new));
    }
}

