/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.skin;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.skin.ConcurrentQueueMap;
import dev.amble.lib.skin.SkinCache;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SkinGrabber {
    public static final SkinGrabber INSTANCE = new SkinGrabber();
    public static final String SKIN_URL = "https://mineskin.eu/skin/";
    public static final String DEFAULT_DIR = "./amblekit/";
    public static final String SKIN_DIR = "./amblekit//skins/";
    private static final ResourceLocation MISSING = new ResourceLocation("amblekit", "textures/skins/error.png");
    private static final String USER_AGENT = "amblekit/1.0";
    private final ConcurrentHashMap<String, ResourceLocation> downloads = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> urls = new ConcurrentHashMap();
    private final ConcurrentQueueMap<String, String> downloadQueue = new ConcurrentQueueMap();
    private final SkinCache cache = new SkinCache();
    public final JerynSkins jeryn = new JerynSkins(new ArrayList<String>());
    private int ticks;
    private boolean connection;

    private SkinGrabber() {
    }

    public static ResourceLocation missing() {
        return MISSING;
    }

    public static String encodeURL(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(input.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getAllKeys() {
        return List.copyOf(this.downloads.keySet());
    }

    @Nullable
    private static NativeImage processLegacySkin(NativeImage image) {
        int i = image.m_85084_();
        int j = image.m_84982_();
        if (j == 64 && (i == 32 || i == 64)) {
            boolean flag;
            boolean bl = flag = i == 32;
            if (flag) {
                NativeImage nativeimage = new NativeImage(64, 64, true);
                nativeimage.m_85054_(image);
                image.close();
                image = nativeimage;
                nativeimage.m_84997_(0, 32, 64, 32, 0);
                nativeimage.m_85025_(4, 16, 16, 32, 4, 4, true, false);
                nativeimage.m_85025_(8, 16, 16, 32, 4, 4, true, false);
                nativeimage.m_85025_(0, 20, 24, 32, 4, 12, true, false);
                nativeimage.m_85025_(4, 20, 16, 32, 4, 12, true, false);
                nativeimage.m_85025_(8, 20, 8, 32, 4, 12, true, false);
                nativeimage.m_85025_(12, 20, 16, 32, 4, 12, true, false);
                nativeimage.m_85025_(44, 16, -8, 32, 4, 4, true, false);
                nativeimage.m_85025_(48, 16, -8, 32, 4, 4, true, false);
                nativeimage.m_85025_(40, 20, 0, 32, 4, 12, true, false);
                nativeimage.m_85025_(44, 20, -8, 32, 4, 12, true, false);
                nativeimage.m_85025_(48, 20, -16, 32, 4, 12, true, false);
                nativeimage.m_85025_(52, 20, -8, 32, 4, 12, true, false);
            }
            SkinGrabber.setNoAlpha(image, 0, 0, 32, 16);
            if (flag) {
                SkinGrabber.doNotchTransparencyHack(image, 32, 0, 64, 32);
            }
            SkinGrabber.setNoAlpha(image, 0, 16, 64, 32);
            SkinGrabber.setNoAlpha(image, 16, 48, 48, 64);
            return image;
        }
        image.close();
        AmbleKit.LOGGER.warn("Discarding incorrectly sized ({}x{}) skin texture", (Object)j, (Object)i);
        return null;
    }

    private static void doNotchTransparencyHack(NativeImage p_118013_, int p_118014_, int p_118015_, int p_118016_, int p_118017_) {
        for (int i = p_118014_; i < p_118016_; ++i) {
            for (int j = p_118015_; j < p_118017_; ++j) {
                int k = p_118013_.m_84985_(i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = p_118014_; l < p_118016_; ++l) {
            for (int i1 = p_118015_; i1 < p_118017_; ++i1) {
                p_118013_.m_84988_(l, i1, p_118013_.m_84985_(l, i1) & 0xFFFFFF);
            }
        }
    }

    private static void setNoAlpha(NativeImage p_118023_, int p_118024_, int p_118025_, int p_118026_, int p_118027_) {
        for (int i = p_118024_; i < p_118026_; ++i) {
            for (int j = p_118025_; j < p_118027_; ++j) {
                p_118023_.m_84988_(i, j, p_118023_.m_84985_(i, j) | 0xFF000000);
            }
        }
    }

    public ResourceLocation getSkin(String name) {
        return this.getSkinOrDownload(name, SKIN_URL + name);
    }

    public Optional<ResourceLocation> getPossibleSkin(String id) {
        if (this.downloads.containsKey(id = id.toLowerCase().replace(" ", "_"))) {
            return Optional.of(this.downloads.get(id));
        }
        return Optional.empty();
    }

    public ResourceLocation getSkinOrDownload(String id, String url) {
        ResourceLocation existing = this.getPossibleSkin(id = id.toLowerCase().replace(" ", "_")).orElse(null);
        if (existing != null) {
            return existing;
        }
        if (this.downloadQueue.get(id) != null) {
            return SkinGrabber.missing();
        }
        url = url.toLowerCase().replace(" ", "_");
        this.enqueueDownload(id, url);
        return SkinGrabber.missing();
    }

    public String getUrl(String key) {
        return this.urls.get(key);
    }

    private ResourceLocation registerSkin(String name) {
        File file = new File(SKIN_DIR + name.toLowerCase().replace(" ", "_") + ".png");
        ResourceLocation location = this.fileToLocation(file);
        this.downloads.put(name, location);
        return location;
    }

    public void clearTextures() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            TextureManager manager = minecraft.m_91097_();
            if (!this.downloads.isEmpty()) {
                this.downloads.forEach((key, value) -> manager.m_118513_(value));
                this.downloads.clear();
            }
        }
    }

    private ResourceLocation fileToLocation(File file) {
        NativeImage image;
        try {
            image = SkinGrabber.processLegacySkin(NativeImage.m_85058_((InputStream)new FileInputStream(file)));
        }
        catch (IOException e) {
            AmbleKit.LOGGER.error("Failed to load Identifier from file", (Throwable)e);
            return SkinGrabber.missing();
        }
        if (image == null) {
            return SkinGrabber.missing();
        }
        return this.registerImage(image);
    }

    private ResourceLocation registerImage(NativeImage image) {
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        return manager.m_118490_("player_", new DynamicTexture(image));
    }

    private static boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void downloadImageFromURL(String filename, File filepath, String URL2) throws IOException {
        URL url = new URL(URL2);
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.connect();
        BufferedImage image = ImageIO.read(connection.getInputStream());
        if (!filepath.exists()) {
            filepath.mkdirs();
        }
        ImageIO.write((RenderedImage)image, "png", new File(filepath, filename + ".png"));
    }

    public void tick() {
        ++this.ticks;
        if (this.connection) {
            return;
        }
        this.downloadNext();
        this.ticks = 0;
    }

    private void enqueueDownload(String id, String url) {
        this.downloadQueue.put(id, url);
        AmbleKit.LOGGER.debug("Enqueued Download {} for {}", (Object)url, (Object)id);
    }

    private void downloadNext() {
        if (this.downloadQueue.isEmpty()) {
            return;
        }
        Pair<String, String> data = this.downloadQueue.remove();
        this.download((String)data.getFirst(), (String)data.getSecond());
    }

    private void download(String id, String url) {
        AmbleKit.LOGGER.debug("Downloading {} for {}", (Object)url, (Object)id);
        if (!SkinGrabber.isValidUrl(url)) {
            AmbleKit.LOGGER.error("Discarding Invalid URL: {}", (Object)url);
            return;
        }
        this.connection = true;
        SkinCache.CacheData data = this.cache.get(id).orElse(null);
        if (data != null) {
            try {
                AmbleKit.LOGGER.debug("Using cached skin for {}", (Object)id);
                this.urls.put(id, data.url());
                this.registerSkin(id);
                this.connection = false;
                return;
            }
            catch (Exception exception) {
                AmbleKit.LOGGER.error("Failed to load cached skin for {}", (Object)id, (Object)exception);
            }
        }
        this.urls.put(id, url);
        new Thread(() -> {
            try {
                this.downloadImageFromURL(id, new File(SKIN_DIR), url);
                this.registerSkin(id);
                this.cache.add(id, url);
                AmbleKit.LOGGER.debug("Downloaded {} for {}!", (Object)url, (Object)id);
            }
            catch (Exception exception) {
                AmbleKit.LOGGER.error("Failed to download {} for {}", new Object[]{url, id, exception});
            }
            finally {
                this.connection = false;
            }
        }, "amblekit-Download").start();
    }

    public boolean hasDownloads() {
        return !this.downloadQueue.isEmpty();
    }

    public int getDownloadsRemaining() {
        return this.downloadQueue.size();
    }

    public void onStopping() {
        this.cache.save();
    }

    public static class JerynSkins
    implements IDownloadSource {
        public static final String JERYN_URL = "https://api.jeryn.dev/mc/skins/random";
        private final ArrayList<String> keys;

        public JerynSkins(ArrayList<String> keys) {
            this.keys = keys;
        }

        @Override
        public boolean isDownloaded() {
            return !this.getTracker().cache.isJerynOutdated() || !this.keys.isEmpty() && new HashSet<String>(this.getTracker().getAllKeys()).containsAll(this.keys);
        }

        @Override
        public void downloadThreaded() {
            try {
                String line;
                if (this.isDownloaded()) {
                    AmbleKit.LOGGER.debug("JerynSkins is already downloaded");
                    return;
                }
                this.getTracker().cache.lastJerynCheck = System.currentTimeMillis();
                URL api = new URL(JERYN_URL);
                URLConnection connection = api.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("User-Agent", SkinGrabber.USER_AGENT);
                connection.connect();
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                JsonElement data = (JsonElement)new GsonBuilder().create().fromJson(stringBuilder.toString(), JsonElement.class);
                if (!data.isJsonArray()) {
                    throw new IllegalStateException("Expected array");
                }
                HashMap<String, String> skins = new HashMap<String, String>();
                data.getAsJsonArray().forEach(element -> {
                    if (!element.isJsonObject()) {
                        throw new IllegalStateException("Expected object");
                    }
                    String url = element.getAsJsonObject().get("link").getAsString();
                    String id = SkinGrabber.encodeURL(url);
                    skins.put(id, url);
                });
                this.keys.clear();
                this.keys.addAll(skins.keySet());
                skins.forEach(INSTANCE::enqueueDownload);
            }
            catch (Exception exception) {
                AmbleKit.LOGGER.error("Failed to download JerynSkins", (Throwable)exception);
            }
        }

        @Override
        public String getId() {
            return "amblekit-JerynSkins";
        }
    }

    public static class SimpleDownloadSource
    implements IDownloadSource {
        protected final Consumer<SimpleDownloadSource> download;
        protected final Function<SimpleDownloadSource, Boolean> isDownloaded;
        private final String id;

        public SimpleDownloadSource(String id, Consumer<SimpleDownloadSource> download, Function<SimpleDownloadSource, Boolean> isDownloaded) {
            this.id = id;
            this.download = download;
            this.isDownloaded = isDownloaded;
        }

        @Override
        public boolean isDownloaded() {
            return this.isDownloaded.apply(this);
        }

        @Override
        public void downloadThreaded() {
            this.download.accept(this);
        }

        @Override
        public String getId() {
            return "amblekit" + this.id;
        }
    }

    public static interface IDownloadSource {
        default public void download() {
            AmbleKit.LOGGER.debug("Downloading {}", (Object)this.getId());
            this.getTracker().connection = true;
            if (this.isDownloaded()) {
                AmbleKit.LOGGER.warn("{} is already downloaded", (Object)this.getId());
            }
            new Thread(() -> {
                try {
                    this.downloadThreaded();
                }
                catch (Exception exception) {
                    AmbleKit.LOGGER.error("Failed to download {}", (Object)this.getId(), (Object)exception);
                }
                finally {
                    this.getTracker().connection = false;
                }
            }, this.getId() + "-Download").start();
        }

        public void downloadThreaded();

        public String getId();

        public boolean isDownloaded();

        default public SkinGrabber getTracker() {
            return INSTANCE;
        }
    }
}

